unit DD56u1;

(*Tidy pchar scraps.*)

(*The setting of output bits seems remarkably complex...
  Via a longint variable,
  For each bit, one routine prepares to set it high, another to set it low.
  THEN a separate routine (datatransfer) the ports bits are set accordingly.

  Not included in this code: There seems to be a mechanism to remember what
  the state of the bits was when power was last removed.*)

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TDD56f1 = class(TForm)
    laIPAddr: TLabel;
    buReadInputs: TButton;
    buClearLow: TButton;
    buSetHi: TButton;
    laInputs: TLabel;
    buSetIP: TButton;
    buQuit: TButton;
    buSetHiLo: TButton;
    procedure FormCreate(Sender: TObject);
    procedure buReadInputsClick(Sender: TObject);
    procedure buSetHiClick(Sender: TObject);
    procedure buClearLowClick(Sender: TObject);
    procedure buSetIPClick(Sender: TObject);
    procedure buQuitClick(Sender: TObject);
    procedure buSetHiLoClick(Sender: TObject);
  private
    { Private declarations }
    wr_iostatus, liTmp:longint;
    pcTmp:pchar;
  public
    { Public declarations }
  end;

function setip(sIPAddr:pchar):pchar; stdcall external 'socket.dll';
function receive:longint; stdcall external 'socket.dll';
function setdata(iToSend:longint):longint; stdcall external 'socket.dll';
function cleandata(iToSend:longint):longint; stdcall external 'socket.dll';
function transfer(iToSend:longint):longint; stdcall external 'socket.dll';

// Valid, but not used in this code: function receivep6:longint; stdcall external 'socket.dll';
//Names seem to be case sensitive. Note "receivep6" to resolve questions
//   of converting from VB listing to Delphi

var
  DD56f1: TDD56f1;

implementation

{$R *.DFM}

procedure TDD56f1.FormCreate(Sender: TObject);
begin
//setip(laIPAddr.caption);
end;

procedure TDD56f1.buReadInputsClick(Sender: TObject);
var I:integer;
begin
I:=receive;
laInputs.caption:=inttostr(I);
end;

procedure TDD56f1.buSetHiClick(Sender: TObject);
begin
wr_iostatus:=Setdata(1);
wr_iostatus:=Setdata(16);
wr_iostatus:=Setdata(2);
wr_iostatus:=Setdata(4);
end;

procedure TDD56f1.buClearLowClick(Sender: TObject);
begin
wr_iostatus:=Cleandata(1 xor $FF);
wr_iostatus:=Cleandata(16 xor $FF);
wr_iostatus:=Cleandata(2 xor $FF);
wr_iostatus:=Cleandata(4 xor $FF);
end;

procedure TDD56f1.buSetIPClick(Sender: TObject);
var sTmp:string;//space for 255.255.255.255 + terminating 0
    pcTmp:pchar;
    liTmp:longint;
begin
sTmp:=laIPAddr.caption;//will clip to 16
showmessage(inttostr(length(sTmp)));
if length(sTmp)>15 then sTmp:=copy(sTmp,1,15);//shouldn't be 15... ignore extra
//StrPCopy(pcTmp,sTmp);
pcTmp:=setip(pchar(sTmp));
//liTmp:=receivep6; Probably to do with seeing what outputs were at last power down
end;

procedure TDD56f1.buQuitClick(Sender: TObject);
begin
application.terminate;
end;

procedure TDD56f1.buSetHiLoClick(Sender: TObject);
begin
liTmp:=transfer(wr_iostatus);
end;

end.
