unit CharonD2u1;
(*CharonD2... for "Charon", Delphi 2 version. Requires the
  WSocket, WSocketE and WSocketS components from Francois Piette's
  FREE (and allowing use in commercial apps) Internet Connection
  Suite (ICS) components. Fear not! If you, like me, dislike the
  idea of installing third party components into your RAD, I
  would say to you: This is a time to make an exception! There
  are versions of ISC for Delphis 1- at least 7, and other languages.
  It is supplied with many demos written in Delphi, and a helpfile.

  I tried Indy... but documentation was hard to find, and things I
  was "supposed" to be able to do didn't work (for me), and you
  need at least Delphi 4. Licensing is generous... I think you can
  put Indy stuff in a commercial product. It should be said in
  support of Indy that I think Borland incorporate it as a standard
  part of more modern Delphis.

  I also tried the HawkNL winsock interface components. Didn't quite
  master them. Anyway... HawkNL is LGPL stuff, hard to use(?) in apps
  you sell?

"ICS" in this does not stand for Internet Connection Sharing, rather,
   it stands for... qfinish  www.overbyte.be

When comment says "In HWG version, was...", it is reporting what
   statement was modified for the ICS environment. Not all revised
   statements are thus marked.

Please note that I have modified many of my usual conventions in order
   that this version of Charon may more closely match the original.

Test data: To try the Hex Send feature, you might want to send any of these:

FF FA 2C 32 00 FF F0
ff fa 2c 33 55 ff f0
ff f1 2c 33 aa ff f0

Minor thing 1st: You can use upper or lower case.

First line will read the inputs and update the on-screen LEDs
Second line will set alternate hardware LEDs on.
Third line will set the OTHER hardware LEDs on, turning off the ones
     the second line command turned on. If you look, you'll see
     the byte that matters... 55 in one command, aa in the other.
     (You can put any hex number, 0 -FF, in that position. 00
     would turn all of the LEDs off.)

Quibbles: In this, and in the original Charon from HWG, the presence of
   the "Read LED" button (which I assume is there to read the inputs,
   hence my renaming of it) made me think that the client won't know
   when inputs change. This isn't true! In at least some cases, changing
   the inputs causes even the HWG Charon to receive a message. My version
   also responds without the need for clicking "Read Inputs". I will
   research this puzzle further.
*)

(*

Fix:
  Shell execute lines
  Shares bug with HWG original: If any i/ps have been on, when
     all go back to 0, an odd character appears... even w/out
     a "read inputs"
  Be sure serial port works! (It passed prelim tests)
  Figure out what NVT is, and whether it is working!
  Fix things so that if you press enter in "Send" box, text is sent
  Put scrollbar on memo
  Add Save and Copy to clipboard for memo

Fine tune?
  check LEDOnOff gives On color for True.... write up.
  Invert action of turn output on/off?
  Rename LED Output?
  AYT -> ABT?  No. Stands for Are You There. Write up.
     Revise note in rems below, if so. Be sure AYT isn't an
     ontegral part of whole command language of Charon
  Write up what NVT is all about.
  See note at SendBtnClick forward decl for detail to resolve.
  Iron out ambiguous use of "Charon" to refer sometimes to the
     software (retain), sometimes to the hardware...
  Refine note about IntState
  Both HWG version and mine report "xyz" from IOC as x NL y NL Z NL.
           Is this something I WANT to fix? Messages from DataDuck came through ok 

Beg?
  Connectors

Hardware ideas
  Extra pads on test pcb
  Proto board

  *)
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons, WSocket;

type
  TCharonD2f1 = class(TForm)
    IPAddress: TEdit;
    IPPort: TEdit;
    ConnectBtn: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
    LED0: TCheckBox;
    LED1: TCheckBox;
    LED2: TCheckBox;
    LED3: TCheckBox;
    LED4: TCheckBox;
    LED5: TCheckBox;
    LED6: TCheckBox;
    LED7: TCheckBox;
    ReadLEDBtn: TButton;
    WriteLEDBtn: TButton;
    Memo: TMemo;
    SendTxt: TEdit;
    ClearBtn: TBitBtn;
    AYTBtn: TBitBtn;
    SendBtn: TBitBtn;
    Image1: TImage;
    CloseBtn: TButton;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    SendHex: TCheckBox;
    NVTFiltr: TCheckBox;
    Label8: TLabel;
    ReadBack: TCheckBox;
    TB0: TShape; //These replace Torrey Button objects of HWG version
    TB1: TShape;
    TB2: TShape;
    TB3: TShape;
    TB4: TShape;
    TB5: TShape;
    TB6: TShape;
    TB7: TShape;
    Label9: TLabel;
    ClientSocket: TWSocket;
    Label10: TLabel;
    HexOutput: TCheckBox;//my first use of FPiette ICS! 24 May 05- TKB

    procedure ConnectBtnClick(Sender: TObject);
    (* this routine handles press of button Connect/Disconnect,
                    opens socket to the target etc. *)

    procedure ClientSocketSessionConnected(Sender: TObject; ErrCode: Word);
    (* Replaced procedure ClientSocketConnect of HWG version.
       I (TKB) believe that the term "callback method" is what I would call an
              event handler. Following, and others like it, from HWG version:
       callback method to inform the program that connection was succesful.
              it enables some buttons, like Send text etc. and makes
                    Charon send <AYT> response *)

    procedure ClientSocketError(Sender: TObject);

    procedure ClientSocketDataAvailable(Sender: TObject; ErrCode: Word);
   (*Replaces HWG version's procedure ClientSocketRead
          Handles event which arises when client socket has received something
             from the server.*)
    (* callback method that parses received data from TCP/IP connection *)


    procedure AYTBtnClick(Sender: TObject);
    (* method to send <are you there> request to the Charon *)

    procedure WriteLEDBtnClick(Sender: TObject);
    (* method to set/clear outputs of Charon according to the checkboxes' states *)

    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    (* callback method, that is called while program is terminating.
       it cleans up the environment, closes socket etc. *)

    procedure ClearBtnClick(Sender: TObject);
    (* method that clears the log window *)

    procedure ReadLEDBtnClick(Sender: TObject);
    (* method that sends a request for Charon to return state of the input lines *)

    procedure SendBtnClick(Sender: TObject);
    (* HWG said....
      method that sends the string from edit box to the Charon's serial output
      ... I wonder if that should be....
      method that sends the string from edit box to the Charon
      What is this "serial OUTPUT" stuff? Input to Charon, isn't it?
      Maybe if SendBtnClick used, not only are DO/DI affected/read, but maybe
      ALSO bytes go out from the device's RS-232? Sort out! Seems likely,
      but untested by TKB*)

    procedure FormCreate(Sender: TObject);
    (* callback method that initializes form's data *)

    procedure FormDestroy(Sender: TObject);
    (* callback method that destroys form's data *)

    procedure CloseBtnClick(Sender: TObject);
    (* method that terminates the program *)

    procedure Label4Click(Sender: TObject);
    procedure Label6Click(Sender: TObject);
    procedure Label7Click(Sender: TObject);
    procedure IPPortChange(Sender: TObject);
    (* these three methods invoke WWW browser or e-mail client to
          respond to the advertisement user clicks *)

    procedure ClientSocketSessionClosed(Sender: TObject; ErrCode: Word);
    (*Replaces HWG version's ClientSocketDisconnect *)
    (* callback method that provides disconnect handling, i.e. setting
            buttons disabled etc. *)

    procedure LEDOnOff(shWhich:TShape;boOn:boolean);
    (*New in TKB version. Used so that 3rd party component could be dispensed with.*)

  private
    { Private declarations }
    procedure HandleButtons( Active : boolean );
    (* method that sets enabled/disabled state of many buttons - it simplifies the code by collecting
       standard responses to one spot *)

  public
    { Public declarations }
  end;

var
  CharonD2f1: TCharonD2f1;

implementation

uses IniFiles{,Removed from HWG version: ShellAPI};

{$R *.DFM}

type TIntState = ( isReadChar, isNVT, isNVTStart, isNVTData, isNVTParam );
(*TKB guess: IntState keeps track of what type of INTerpretation we should
    currently be executing... i.e. does FF mean "turn all LEDs on" or is
    it a token, part of the command language, etc.*)

const IntState : TIntState = isReadChar;

procedure TCharonD2f1.ConnectBtnClick(Sender: TObject);
begin
(*In HWG version was...  if ClientSocket.Active then begin*)
if ClientSocket.state<>wsClosed then begin
    //Only needed in HWG version. ClientSocket.Active := false;
    ClientSocket.close;//Needed in TKB version to replace ClientSocket.Active := false;
    ConnectBtn.Caption := 'Connect';
    HandleButtons( false );
  end else begin   
    with ClientSocket do begin
      Addr := IPAddress.Text;
      Port := IPPort.Text;//Previous version's socket's port type was numeric
      Proto:='TCP';
      Connect;
      //Only needed in HWG version. Active := true;
    end;
    SendTxt.SetFocus;
  end;
end;

procedure TCharonD2f1.ClientSocketSessionConnected(Sender: TObject;
  ErrCode: Word);
(*Replaces ClientSocketConnect of HWG version.
  Handles event generated by connection of ClientSocket to a server.*)
begin
  ConnectBtn.Caption := 'Disconnect';
  HandleButtons(true);
  ClientSocket.SendStr(#$FF#$F6);//Sends "Are You There", which should
       // prompt reply with Charon version, etc, info.
end;

procedure TCharonD2f1.ClientSocketError(Sender: TObject);
(*Note that this is similar to HWG version, but tweaked, in part for differences
      in the parameters passed to the routine.
  Handles OnError event from ClientSocket*)
var ErrorCode: integer;
begin
  ErrorCode:=ClientSocket.LastError;
  Memo.Lines.Add( 'Socket error: ' + IntToStr( ErrorCode ) );
  if ErrorCode = 10053 then begin
      ConnectBtnClick(self );
      MessageDlg(
      'Charon I disconnected after socket timeout.'#13+
      {qrevise following text...}
      'If you wish to prevent this, turn on the "NVT Keep connection"'#13+
      'Charon feature and "NVT filter" in this program.', mtWarning, [ mbOK ], 0 );
  end;
  ErrorCode := 0;
end;


procedure TCharonD2f1.HandleButtons(Active: boolean);
(*Enables / disables sundry buttons on form. Called from various
  places so that you can/cannot attempt things which are/are not
  appropriate when you are/are not connected the server.*)
begin
  SendBtn.Enabled := Active;
  AYTBtn.Enabled := Active;
  ReadLEDBtn.Enabled := Active;
  WriteLEDBtn.Enabled := Active;
  ReadBack.Enabled := Active;
end;

procedure TCharonD2f1.AYTBtnClick(Sender: TObject);
begin
 ClientSocket.SendStr( #$FF#$F6 );//Sends "Are You There", which should
       // prompt reply with Charon version, etc, info.
end;

procedure TCharonD2f1.LEDOnOff(shWhich:TShape;boOn:boolean);
(*New since HWG version. See notes where called.
  shWhich is which shape is to be (re-)painted.
  boOn determines what color is it painted.*)
begin
if boOn then shWhich.brush.color:=clLime // no ; here
        else shWhich.brush.color:=clGreen;
end;

procedure TCharonD2f1.ClientSocketDataAvailable(Sender: TObject;
  ErrCode: Word);
(*Replaces HWG version's procedure ClientSocketRead
          Handles event which arises when client socket has received something
             from the server.*)
var s2 : string;
    i,iLimit : integer;
    s:string[255];
    sBuffHex:string;//added by TKB, mostly for debugging
    bTmp:byte;
(*Scrap from a demo program...
    Len := CliSocket.Receive(@Buffer, SizeOf(Buffer) - 1);
    if Len <= 0 then
        Exit;
    Buffer[Len]       := #0;
*)
begin  //ClientSocketDataAvailable
  (*First, something equivalent to HWG versions's
        s := Socket.ReceiveText;....
        Function Receive(Buffer : Pointer; BufferSize: integer): integer; *)
  i:=ClientSocket.receive(@s,SizeOf(s) - 1);
  iLimit:=i-1;
  if i>252 then showmessage('Program expects packets of < about 254... but could be revised.');
  if i<= 0 then Exit;//If i negative or 0, there was some problem. Provide error msg
  s[i]:=chr(0);
  sBuffHex:='';
  s2 := '';
  (*N.B.: Next line should not be...
  for i := 1 to Length( s ) do
  ...as in HWG version, despite similar socket.receive*)
  for i := 0 to iLimit do begin //FL1 (Block scope reminder)
    sBuffHex:=sBuffHex+inttohex(ord(s[i]),2)+' ';
    case IntState of  //CL2
    isReadChar:
      case s[ i ] of //CL3
      #$FF: IntState := isNVT;
      //Umm... next "if" is odd... but appears in HWG version
      #$F1: if not NVTFiltr.Checked then
        s2 := s2 + s[ i ]; // we handle NOP's another way <What it says in HWG ver. True?
      else
        s2 := s2 + s[ i ]
      end;           //CL3
    isNVT:
      case s[ i ] of
      #$FF: s2 := s2 + #$FF; // two FF's one after one
      #$FA: IntState := isNVTStart; // beginning of NVT command
      #$F0: IntState := isReadChar; // regular NVT command end
      else
        IntState := isReadChar; // two-char command (for example NOP)
      end;
    isNVTStart:
      case s[ i ] of
      #$FF: IntState := isNVT; // end of NVT
      #$2C: IntState := isNVTData; // we read COM data
      end;
    isNVTData:
      case s[ i ] of    //CL3
      #$FF: IntState := isNVT;
//      #$97: IntState := isNVTParam;  <- This remmed out in HWG version, too.
      #$96: IntState := isNVTParam;
      end;              //CL3
    isNVTParam: begin   //CL3
      (*This block: Use of...
         ( Ord( s[ i ] ) and ( 1 shl 0 ) ) = 0)
         ....etc. taken from HWG version of program.
         LEDOnOff produced by TKB, so that program could drop
         TorreyButton 3rd party component. The component was probably
         fine... but not NEEDED.*)
      bTmp:=ord(s[i]);
      LEDOnOff(TB0,(bTmp and ( 1 shl 0 ) ) = 0);// Replaces original's TB0.LedOn := ( Ord( s[ i ] ) and ( 1 shl 0 ) ) = 0;
      LEDOnOff(TB1,(bTmp and ( 1 shl 1 ) ) = 0);
      LEDOnOff(TB2,(bTmp and ( 1 shl 2 ) ) = 0);
      LEDOnOff(TB3,(bTmp and ( 1 shl 3 ) ) = 0);
      LEDOnOff(TB4,(bTmp and ( 1 shl 4 ) ) = 0);
      LEDOnOff(TB5,(bTmp and ( 1 shl 5 ) ) = 0);
      LEDOnOff(TB6,(bTmp and ( 1 shl 6 ) ) = 0);
      LEDOnOff(TB7,(bTmp and ( 1 shl 7 ) ) = 0);
      IntState := isNVTStart;
    end;   //CL3
    end;   //CL2     
    end;   //FL1
  if s2 <> '' then
    Memo.Lines.Add(s2);
  if (sBuffHex<>'') and (HexOutput.checked) then
    Memo.Lines.Add(sBuffHex);
end;  //ClientSocketDataAvailable

procedure TCharonD2f1.WriteLEDBtnClick(Sender: TObject);
var Zn : char;
begin
  Zn := Chr( 255 - (
    Ord( LED0.Checked ) shl 0 +
    Ord( LED1.Checked ) shl 1 +
    Ord( LED2.Checked ) shl 2 +
    Ord( LED3.Checked ) shl 3 +
    Ord( LED4.Checked ) shl 4 +
    Ord( LED5.Checked ) shl 5 +
    Ord( LED6.Checked ) shl 6 +
    Ord( LED7.Checked ) shl 7 ) );
    ClientSocket.SendStr(#$FF#$FA#$2C#$33+Zn+#$FF#$F0);
  if ReadBack.Checked then
    ReadLEDBtnClick( self );
end;

procedure TCharonD2f1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  ClientSocket.close;//In GWH version, was  ClientSocket.Active := false;
end;

procedure TCharonD2f1.ClearBtnClick(Sender: TObject);
begin
memo.clear;
end;

procedure TCharonD2f1.ReadLEDBtnClick(Sender: TObject);
begin
 ClientSocket.SendStr( #$FF#$FA#$2C#$32#$00#$FF#$F0 ); //was ClientSocket.Socket.SendText(..
end;

procedure TCharonD2f1.SendBtnClick(Sender: TObject);
(*See comments near this source code's start.*)
  function CheckHEX( S : string; var GO : string ) : boolean;
  var i : integer;
  begin
    Result := false;
    GO := '';
    S := UpperCase( Trim( S ) + ' ' );
    if Length( S ) mod 3 > 0 then // has to be divisible by 3
      exit;
    for i := 1 to Length( S ) do
      case i mod 3 of
      0 : if S[ i ] in [ 'A'..'F', '0'..'9' ] then exit; // hexa digits are not allowed
      1 : if not ( S[ i ] in [ 'A'..'F', '0'..'9' ] ) then exit;
      2 : if not ( S[ i ] in [ 'A'..'F', '0'..'9' ] ) then
            exit
          else begin
            GO := GO + Chr( StrToInt( '$'+S[ i - 1 ] + S[ i ] ) );
          end;
      end;
    Result := true;
  end;

var ToSend : string;

begin
  ToSend := SendTxt.Text;
  try
    if SendHex.Checked then
      if not CheckHEX( ToSend, ToSend ) then begin
        MessageDlg( 'Error in HEX string: It must consist of TWO hexa digits'#13+
          'followed by a space, repeated as many times as you like.'#13+
          'ff fa 2c 32 00 ff f0 will read the inputs.', mtError, [ mbOK ], 0 );
        exit;
      end;
    ClientSocket.SendStr(ToSend)
  finally
    SendTxt.SetFocus;
  end;
end;

procedure TCharonD2f1.FormCreate(Sender: TObject);
(*This, from HWG version, is a nice touch... but not central
     to the work of Charon. It and what's in FormDestroy
     save you the hassle of re-entering your usual details
     each time you start the program. Works fine if no
     ini file present when prgm first run.*)
var F : TIniFile;
begin
  F := TIniFile.Create( ChangeFileExt( Application.ExeName, '.ini' ) );
  IPAddress.Text := F.ReadString( 'Settings', 'IPAddress', '192.168.0.25' );
  IPPort.Text := F.ReadString( 'Settings', 'Port', '80' );
//HWG version was:  IPPort.Value := F.ReadInteger( 'Settings', 'Port', 2000 );
  NVTFiltr.Checked := F.ReadBool( 'Settings', 'FilterEcho', true );
  ReadBack.Checked := F.ReadBool( 'Settings', 'ReadBack', true );
  HexOutput.Checked:= F.ReadBool( 'Settings', 'HexOut', true );
  F.Free;
end;

procedure TCharonD2f1.FormDestroy(Sender: TObject);
(*This, from HWG version, is a nice touch... but not central
     to the work of Charon. It and what's in FormCreate
     save you the hassle of re-entering your usual details
     each time you start the program. Works fine if no
     ini file present when prgm first run.*)
var F : TIniFile;
begin
  F := TIniFile.Create( ChangeFileExt( Application.ExeName, '.ini' ) );
  F.WriteString( 'Settings', 'IPAddress', IPAddress.Text );
  F.WriteString( 'Settings', 'Port', IPPort.Text );
//HWG version was:  F.WriteInteger( 'Settings', 'Port', IPPort.Value );
  F.WriteBool( 'Settings', 'FilterEcho', NVTFiltr.Checked );
  F.WriteBool( 'Settings', 'ReadBack', ReadBack.Checked );
  F.WriteBool( 'Settings', 'HexOut', HexOutput.Checked );
end;

procedure TCharonD2f1.CloseBtnClick(Sender: TObject);
begin
  Close;
end;

procedure TCharonD2f1.Label4Click(Sender: TObject);
begin
showmessage('Not implemented. Skeleton in place.');
//  ShellExecute( 0, 'open', 'http://www.hwgroup.cz', nil, nil, SW_NORMAL );
end;

procedure TCharonD2f1.Label6Click(Sender: TObject);
begin
showmessage('Not implemented. Skeleton in place.');
//  ShellExecute( 0, 'open', 'mailto:dresler@hw.cz', nil, nil, SW_NORMAL );
end;

procedure TCharonD2f1.Label7Click(Sender: TObject);
begin
showmessage('Not implemented. Skeleton in place.');
//  ShellExecute( 0, 'open', 'http://www.hwgroup.cz/products/charon1/index_en.html',
//    nil, nil, SW_NORMAL );
end;

procedure TCharonD2f1.ClientSocketSessionClosed(Sender: TObject;
  ErrCode: Word);
(*From ICS documentation:
      The OnSessionClosed event is generated when the socket is
      closed, either by an explicit call to the close method or
      by the remote side closing the connection.
  Replaces HWG version's ClientSocketDisconnect*)
begin
  ConnectBtn.Caption := 'Connect';
  HandleButtons( false );
end;



procedure TCharonD2f1.IPPortChange(Sender: TObject);
//No SpinEdit component in Delphi 2, so data validation done this way.
var boTmp:boolean;
    sTmp:string;
    c1:byte;
begin
boTmp:=true;//Start with idea that all characters are valid
sTmp:=IPPort.text;
for c1:=1 to length(sTmp) do
  if pos(sTmp[c1],'0123456789')=0 then boTmp:=false;
if length(sTmp)<1 then boTmp:=false;
if boTmp then ConnectBtn.enabled:=true else ConnectBtn.enabled:=false;
end;

end.
