unit DD58u1;
(*Program to demonstate operation of HW group's I/O Controller.
  (see http://sheepdogsoftware.co.uk/sc9hwioc.htm for more)
  written in Delphi 2, using the WSocket, WSocketE and WSocketS
  components from Francois Piette's FREE (and allowing use in
  commercial apps) Internet Connection Suite (ICS) components.
  Fear not! If you, like me, dislike the idea of installing third
  party components into your Delphi environment, I would say to
  you: This is a time to make an exception! There are versions
  of ISC for Delphis 1- at least 7, and other languages.
  It is supplied with many demos written in Delphi, and a helpfile.
  (See www.overbyte.be (BE, (Belgium) not COM) for more on ICS.)

  I tried Indy... but documentation was hard to find, and things I
  was "supposed" to be able to do didn't work (for me), and you
  need at least Delphi 4. Licensing is generous... I think you can
  put Indy stuff in a commercial product. It should be said in
  support of Indy that I think Borland incorporate it as a standard
  part of more modern Delphis.

  I also tried the HawkNL winsock interface components. Didn't quite
  master them. Anyway... HawkNL is LGPL stuff, hard to use(?) in apps
  you sell? I m new to this internet component "thing"! (5/06)

When comment says "In HWG version, was...", it is reporting what
   statement was modified for the ICS environment. Not all revised
   statements are thus marked.

=================
Credits: Much of this material is (c) TK Boyd, 6/05, but you may use
it if...

You give credit in your sourcecode, including a reference to
HW group, Prague, www.hw-group.com
Delphi Tutorials: http://sheepdogguides.com/tut.htm
and
Franois Piette's Internet Components Suite,
http:// www.overbyte.be (N.B.: "BE", not "COM")

If your program is little changed from this program, I would be
grateful if one or both of the above web links appeared on
what users see when they run the program, or if they pop up
an "about" panel. However, if your program is significantly changed
from mine, I'll understand if you "bury" these references.

When I say "you may use it", I include use in commercial products.

Please note: Any such use is allowed only if you accept responsibility
for all consequences arising. I was assured by HW group that the material
I adapted from the program I obtained from them could be released this
way. The terms of the ICS are viewable on the web. Those sources, and
my own work, are all that went into this.

==================
Please note that I have modified many of my usual conventions in order
   to keep this program close to the demo programs supplied by HW group.

Test data: To try the Hex Send feature, you might want to send any of these:

FF FA 2C 32 00 FF F0
ff fa 2c 33 55 ff f0
ff f1 2c 33 aa ff f0

First line will read the inputs and update the on-screen (virtual) LEDs
Second line will turn some of the I/O controller's outputs on, some off.
Third line will set the OTHER outputs on, turning off the ones
     the second line command turned on. If you look, you'll see
     the byte that matters... 55 in one command, aa in the other.
     (You can put any hex number, 0 to FF, in that position. 00
     would turn all of the outputs off.)

Minor point, already illustrated: You can use upper or lower case.

You will see references to "Charon". Charon is the "heart" of the
   I/O Controller, and of some other HG group devices.

Quibbles: In this, and in the original Charon from HWG, the presence of
   the "Read LED" button (which I assume was there to read the inputs,
   hence my renaming of it tyo "buReadInputs") made me think that the
   client won't know when inputs change. This isn't true!
   In at least some cases, changing the inputs causes even the
   HWG Charon to receive a message. My version also responds without
   the need for clicking "Read Inputs". I will research this puzzle further.
*)

(*

Fix:
  Shell execute lines
  Shares bug with HWG original: If any i/ps have been on, when
     all go back to 0, an odd character appears... even w/out
     a "read inputs"
  Do more in respect of Network Virtual serial Terminal, (NVT)
      and be sure it is working fully. (It passed prelim tests)

Fine tune?
  Write up what NVT is all about.
  See note at SendBtnClick forward decl for detail to resolve.
  Iron out ambiguous use of "Charon" to refer sometimes to the
     software (retain), sometimes to the hardware...
  Refine note about IntState
  Both HWG version and mine report "xyz" from IOC as x NL y NL Z NL.
           Is this something I WANT to fix? Messages from DataDuck came through ok 
  Add Save and Copy to clipboard for memo?

Beg?
  Connectors

Hardware ideas
  Extra pads on test pcb?
  Proto board - opto isolators / relay drivers?

  *)
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons, WSocket;

type
  TDD58f1 = class(TForm)
    IPAddress: TEdit;
    IPPort: TEdit;
    buConnect: TBitBtn;
    laIPAddrTxt: TLabel;
    laTCPTxt: TLabel;
    Memo: TMemo;
    SendTxt: TEdit;
    ClearBtn: TBitBtn;
    AYTBtn: TBitBtn;
    SendBtn: TBitBtn;
    Image1: TImage;
    CloseBtn: TButton;
    laPoweredTxt: TLabel;
    laHWGTxt: TLabel;
    laAndTxt: TLabel;
    laTomasTxt: TLabel;
    laIOContTxt: TLabel;
    SendHex: TCheckBox;
    NVTFiltr: TCheckBox;
    laLogNRecTextTxt: TLabel;
    laTKBInfo1txt: TLabel;
    ClientSocket: TWSocket;
    laTKBInfo2Txt: TLabel;
    HexOutput: TCheckBox;
    paIn: TPanel;
    TB0: TShape;
    TB1: TShape;
    TB2: TShape;
    TB3: TShape;
    TB4: TShape;
    TB5: TShape;
    TB6: TShape;
    TB7: TShape;
    buReadInputs: TButton;
    laIn0Txt: TLabel;
    laIn1Txt: TLabel;
    laIn2Txt: TLabel;
    laIn3Txt: TLabel;
    laIn4Txt: TLabel;
    laIn5Txt: TLabel;
    laIn6Txt: TLabel;
    laIn7Txt: TLabel;
    paOut: TPanel;
    laOut0Txt: TLabel;
    laOut1Txt: TLabel;
    laOut2Txt: TLabel;
    laOut3Txt: TLabel;
    laOut4Txt: TLabel;
    laOut5Txt: TLabel;
    laOut6Txt: TLabel;
    laOut7Txt: TLabel;
    LED0: TCheckBox; //N.B. "LED" in this context could be confusing.
    LED1: TCheckBox; //  These controls relate to the I/O Controller's
    LED2: TCheckBox; //  OUTPUTs, which may, of course, be drivong LEDs.
    LED3: TCheckBox;
    LED4: TCheckBox;
    LED5: TCheckBox;
    LED6: TCheckBox;
    LED7: TCheckBox;
    cbReadRepeatedly: TCheckBox;
    Timer1: TTimer;
    laReadFreq: TLabel;
    shTickTock: TShape;
    buPrettyPattern: TButton;
    Timer2: TTimer;

    procedure buConnectClick(Sender: TObject);
    (* this routine handles press of button Connect/Disconnect,
                    opens socket to the target etc. *)

    procedure ClientSocketSessionConnected(Sender: TObject; ErrCode: Word);
    (* Replaced procedure ClientSocketConnect of HWG version.
       I (TKB) believe that the term "callback method" is what I would call an
              event handler. Following, and others like it, from HWG version:
       "callback method to inform the program that connection was succesful.
              it enables some buttons, like Send text etc. and makes
                    I/O Controller send response to "Are You There" enquiry." *)

    procedure ClientSocketError(Sender: TObject);

    procedure ClientSocketDataAvailable(Sender: TObject; ErrCode: Word);
   (*Replaces HWG version's procedure ClientSocketRead
          Handles event which arises when client socket has received something
             from the server.*)
    (* callback method that parses received data from TCP/IP connection *)


    procedure AYTBtnClick(Sender: TObject);
    (* method to send "Are You There?" enquiry to the I/O Controller *)

    procedure WriteLEDs(bTmp:byte);//TKB procedure, drawn from original of previous

    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    (* callback method, that is called while program is terminating.
       it cleans up the environment, closes socket etc. *)

    procedure ClearBtnClick(Sender: TObject);
    (* method that clears the log window *)

    procedure buReadInputsClick(Sender: TObject);
    (* method that sends a request for I/O Controller to return state of the input lines *)
    procedure ReadInputs;//TKB Procedure, drawn from original of previous

    procedure SendBtnClick(Sender: TObject);
    (* HWG said....
      method that sends the string from edit box to the I/O Controller's serial output
      ... I wonder if that should be....
      method that sends the string from edit box to the I/O Controller
      What is this "serial OUTPUT" stuff? Input to I/O Controller, isn't it?
      Maybe if SendBtnClick used, not only are DO/DI affected/read, but maybe
      ALSO bytes go out from the device's RS-232? Sort out! Seems likely,
      but untested by TKB*)

    procedure FormCreate(Sender: TObject);
    (* callback method that initializes form's data *)

    procedure FormDestroy(Sender: TObject);
    (* callback method that destroys form's data *)

    procedure CloseBtnClick(Sender: TObject);
    (* method that terminates the program *)

    procedure laHWGTxtClick(Sender: TObject);
    procedure laTomasTxtClick(Sender: TObject);
    procedure laIOContTxtClick(Sender: TObject);
    procedure IPPortChange(Sender: TObject);
    (* these three methods invoke WWW browser or e-mail client to
          respond to the advertisement user clicks *)

    procedure ClientSocketSessionClosed(Sender: TObject; ErrCode: Word);
    (*Replaces HWG version's ClientSocketDisconnect *)
    (* callback method that provides disconnect handling, i.e. setting
            buttons disabled etc. *)

    procedure LEDOnOff(shWhich:TShape;boOn:boolean);
    procedure LED0Click(Sender: TObject);
    procedure cbReadRepeatedlyClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure buPrettyPatternClick(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
    procedure IPAddressChange(Sender: TObject);
    procedure SendTxtKeyPress(Sender: TObject; var Key: Char);
    (*New in TKB version. Used so that 3rd party component could be dispensed with.*)

  private
    { Private declarations }
    bTmp:byte;
    iPP:integer;
    
    procedure HandleButtons( Active : boolean );
    (* method that sets enabled/disabled state of many buttons - it simplifies
       the code by collecting standard responses to one spot *)
    procedure TickTock;//TKB proc
    procedure DoWriteLEDs(bTmp:byte);
      //my first use of FPiette ICS! 24 May 05- TKB
    function boValidIPAddr(sTmp:string):boolean;


  public
    { Public declarations }
  end;

var
  DD58f1: TDD58f1;

implementation

uses IniFiles{,Removed from HWG version: ShellAPI};

{$R *.DFM} //Resources mgmnt
{$R+} //Range checking... worth it's weight in gold.

type TIntState = ( isReadChar, isNVT, isNVTStart, isNVTData, isNVTParam );
(*TKB guess: IntState keeps track of what type of INTerpretation we should
    currently be executing... i.e. does FF mean "turn all LEDs on" or is
    it a token, part of the command language, etc.*)

const version='Version: 18 June 2005';//Keep all text
      IntState : TIntState = isReadChar;

procedure TDD58f1.buConnectClick(Sender: TObject);
begin
(*In HWG version was...  if ClientSocket.Active then begin*)
if ClientSocket.state<>wsClosed then begin
    //Only needed in HWG version. ClientSocket.Active := false;
    ClientSocket.close;//Needed in TKB version to replace ClientSocket.Active := false;
    buConnect.Caption := '&Connect';
    if boValidIPAddr(IPAddress.text)=false then buConnect.enabled:=false;
    HandleButtons( false );
    Timer1.enabled:=false;
    cbReadRepeatedly.checked:=false;
    TB0.brush.color:=clGray;TB1.brush.color:=clGray;
    TB2.brush.color:=clGray;TB3.brush.color:=clGray;
    TB4.brush.color:=clGray;TB5.brush.color:=clGray;
    TB6.brush.color:=clGray;TB7.brush.color:=clGray;
  end else begin   
    with ClientSocket do begin
      Addr := IPAddress.Text;
      Port := IPPort.Text;//Previous version's socket's port type was numeric
      Proto:='TCP';
      Connect;
      //Only needed in HWG version. Active := true;
    end;
    SendTxt.SetFocus;
  end;
end;

procedure TDD58f1.ClientSocketSessionConnected(Sender: TObject;
  ErrCode: Word);
(*Replaces ClientSocketConnect of HWG version.
  Handles event generated by connection of ClientSocket to a server.*)
begin
  buConnect.Caption := '&Disconnect';
  HandleButtons(true);
  ClientSocket.SendStr(#$FF#$F6);//Sends "Are You There", which should
       // prompt reply with I/O Controller version, etc, info.
end;

procedure TDD58f1.ClientSocketError(Sender: TObject);
(*Note that this is similar to HWG version, but tweaked, in part for differences
      in the parameters passed to the routine.
  Handles OnError event from ClientSocket*)
var ErrorCode: integer;
begin
  ErrorCode:=ClientSocket.LastError;
  Memo.Lines.Add( 'Socket error: ' + IntToStr( ErrorCode ) );
  if ErrorCode = 10053 then begin
      buConnectClick(self);
      MessageDlg(
      'I/O Controller disconnected after socket timeout.'#13+
      {qrevise following text...}
      'If you wish to prevent this, turn on the "NVT Keep connection"'#13+
      'I/O Controller feature and "NVT filter" in this program.', mtWarning, [ mbOK ], 0 );
  end;
  ErrorCode := 0;
end;


procedure TDD58f1.HandleButtons(Active: boolean);
(*Enables / disables sundry buttons on form. Called from various
  places so that you can/cannot attempt things which are/are not
  appropriate when you are/are not connected the server.*)
begin
  SendBtn.Enabled := Active;
  AYTBtn.Enabled := Active;
  buReadInputs.Enabled:= Active;
  LED0.enabled:=Active;LED1.enabled:=Active;
  LED2.enabled:=Active;LED3.enabled:=Active;
  LED4.enabled:=Active;LED5.enabled:=Active;
  LED6.enabled:=Active;LED7.enabled:=Active;
  cbReadRepeatedly.enabled:=Active;
  buPrettyPattern.enabled:=Active;
end;

procedure TDD58f1.AYTBtnClick(Sender: TObject);
begin
 ClientSocket.SendStr( #$FF#$F6 );//Sends "Are You There?", which should
       // prompt reply with I/O Controller version, etc, info.
end;

procedure TDD58f1.LEDOnOff(shWhich:TShape;boOn:boolean);
(*New since HWG version. See notes where called.
  shWhich is which shape is to be (re-)painted.
  boOn determines what color is it painted.*)
begin
if boOn then shWhich.brush.color:=clLime // no ; here
        else shWhich.brush.color:=clGreen;
end;

procedure TDD58f1.ClientSocketDataAvailable(Sender: TObject;
  ErrCode: Word);
(*Replaces HWG version's procedure ClientSocketRead
          Handles event which arises when client socket has received something
             from the server.*)
var s2 : string;
    i,iLimit : integer;
    s:string[255];
    sBuffHex:string;//added by TKB, mostly for debugging
    bTmp:byte;
(*Scrap from a demo program...
    Len := CliSocket.Receive(@Buffer, SizeOf(Buffer) - 1);
    if Len <= 0 then
        Exit;
    Buffer[Len]       := #0;
*)
begin  //ClientSocketDataAvailable
  (*First, something equivalent to HWG versions's
        s := Socket.ReceiveText;....
        Function Receive(Buffer : Pointer; BufferSize: integer): integer; *)
  i:=ClientSocket.receive(@s,SizeOf(s) - 1);
  iLimit:=i-1;
  if i>252 then showmessage('Program expects packets of < about 254... but could be revised.');
  if i<= 0 then Exit;//If i negative or 0, there was some problem. Provide error msg
  s[i]:=chr(0);
  sBuffHex:='';
  s2 := '';
  (*N.B.: Next line should not be...
  for i := 1 to Length( s ) do
  ...as in HWG version, despite similar socket.receive*)
  for i := 0 to iLimit do begin //FL1 (Block scope reminder)
    sBuffHex:=sBuffHex+inttohex(ord(s[i]),2)+' ';
    case IntState of  //CL2
    isReadChar:
      case s[ i ] of //CL3
      #$FF: IntState := isNVT;
      //Umm... next "if" is odd... but appears in HWG version
      #$F1: if not NVTFiltr.Checked then
        s2 := s2 + s[ i ]; // we handle NOP's another way <What it says in HWG ver. True?
      else
        s2 := s2 + s[ i ]
      end;           //CL3
    isNVT:
      case s[ i ] of
      #$FF: s2 := s2 + #$FF; // two FF's one after one
      #$FA: IntState := isNVTStart; // beginning of NVT command
      #$F0: IntState := isReadChar; // regular NVT command end
      else
        IntState := isReadChar; // two-char command (for example NOP)
      end;
    isNVTStart:
      case s[ i ] of
      #$FF: IntState := isNVT; // end of NVT
      #$2C: IntState := isNVTData; // we read COM data
      end;
    isNVTData:
      case s[ i ] of    //CL3
      #$FF: IntState := isNVT;
//      #$97: IntState := isNVTParam;  <- This remmed out in HWG version, too.
      #$96: IntState := isNVTParam;
      end;              //CL3
    isNVTParam: begin   //CL3
      (*This block: Use of...
         ( Ord( s[ i ] ) and ( 1 shl 0 ) ) = 0)
         ....etc. taken from HWG version of program.
         LEDOnOff produced by TKB, so that program could drop
         TorreyButton 3rd party component. The component was probably
         fine... but not NEEDED.*)
      bTmp:=ord(s[i]);
      LEDOnOff(TB0,(bTmp and ( 1 shl 0 ) ) = 0);// Replaces original's TB0.LedOn := ( Ord( s[ i ] ) and ( 1 shl 0 ) ) = 0;
      LEDOnOff(TB1,(bTmp and ( 1 shl 1 ) ) = 0);
      LEDOnOff(TB2,(bTmp and ( 1 shl 2 ) ) = 0);
      LEDOnOff(TB3,(bTmp and ( 1 shl 3 ) ) = 0);
      LEDOnOff(TB4,(bTmp and ( 1 shl 4 ) ) = 0);
      LEDOnOff(TB5,(bTmp and ( 1 shl 5 ) ) = 0);
      LEDOnOff(TB6,(bTmp and ( 1 shl 6 ) ) = 0);
      LEDOnOff(TB7,(bTmp and ( 1 shl 7 ) ) = 0);
      IntState := isNVTStart;
    end;   //CL3
    end;   //CL2     
    end;   //FL1
  if s2 <> '' then
    Memo.Lines.Add(s2);
  if (sBuffHex<>'') and (HexOutput.checked) then
    Memo.Lines.Add(sBuffHex);
end;  //ClientSocketDataAvailable

procedure TDD58f1.WriteLEDs;
begin
 bTmp:=(
    Ord(LED0.Checked ) shl 0 +
    Ord(LED1.Checked ) shl 1 +
    Ord(LED2.Checked ) shl 2 +
    Ord(LED3.Checked ) shl 3 +
    Ord(LED4.Checked ) shl 4 +
    Ord(LED5.Checked ) shl 5 +
    Ord(LED6.Checked ) shl 6 +
    Ord(LED7.Checked ) shl 7 );
DoWriteLEDs(bTmp);
end;

procedure TDD58f1.DoWriteLEDs(bTmp:byte);
var Zn : char;
begin
  Zn := Chr(bTmp);
    ClientSocket.SendStr(#$FF#$FA#$2C#$33+Zn+#$FF#$F0);
end;


procedure TDD58f1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  ClientSocket.close;//In GWH version, was  ClientSocket.Active := false;
end;

procedure TDD58f1.ClearBtnClick(Sender: TObject);
begin
memo.clear;
end;

procedure TDD58f1.buReadInputsClick(Sender: TObject);
//Old name... misleading. Reads inputs, sets virtural LEDs on or off
begin
 ReadInputs;
 TickTock;
end;


procedure TDD58f1.ReadInputs;
begin
 ClientSocket.SendStr( #$FF#$FA#$2C#$32#$00#$FF#$F0 ); //was ClientSocket.Socket.SendText(..
end;



procedure TDD58f1.SendBtnClick(Sender: TObject);
(*See comments near this source code's start.*)
  function CheckHEX( S : string; var GO : string ) : boolean;
  var i : integer;
  begin
    Result := false;
    GO := '';
    S := UpperCase( Trim( S ) + ' ' );
    if Length( S ) mod 3 > 0 then // has to be divisible by 3
      exit;
    for i := 1 to Length( S ) do
      case i mod 3 of
      0 : if S[ i ] in [ 'A'..'F', '0'..'9' ] then exit; // hexa digits are not allowed
      1 : if not ( S[ i ] in [ 'A'..'F', '0'..'9' ] ) then exit;
      2 : if not ( S[ i ] in [ 'A'..'F', '0'..'9' ] ) then
            exit
          else begin
            GO := GO + Chr( StrToInt( '$'+S[ i - 1 ] + S[ i ] ) );
          end;
      end;
    Result := true;
  end;

var ToSend : string;

begin
  ToSend := SendTxt.Text;
  try
    if SendHex.Checked then
      if not CheckHEX( ToSend, ToSend ) then begin
        MessageDlg( 'Error in HEX string: It must consist of TWO hexa digits'#13+
          'followed by a space, repeated as many times as you like.'#13+
          'ff fa 2c 32 00 ff f0 will read the inputs.', mtError, [ mbOK ], 0 );
        exit;
      end;
    ClientSocket.SendStr(ToSend)
  finally
    SendTxt.SetFocus;
  end;
end;

procedure TDD58f1.FormCreate(Sender: TObject);
(*This, from HWG version, is a nice touch... but not central
     to the work of this program. It and what's in FormDestroy
     save you the hassle of re-entering your usual details
     each time you start the program. Works fine if no
     ini file present when prgm first run.*)
var F : TIniFile;
begin
  F := TIniFile.Create( ChangeFileExt( Application.ExeName, '.ini' ) );
  IPAddress.Text := F.ReadString( 'Settings', 'IPAddress', '192.168.0.25' );
  IPPort.Text := F.ReadString( 'Settings', 'Port', '80' );
//HWG version was:  IPPort.Value := F.ReadInteger( 'Settings', 'Port', 2000 );
  NVTFiltr.Checked := F.ReadBool( 'Settings', 'FilterEcho', true );
  HexOutput.Checked:= F.ReadBool( 'Settings', 'HexOut', true );
  F.Free;
  DD58f1.caption:='I/O Controller Exerciser (DD58) www.sheepdogsoftware.co.uk ('+version+')';
  application.title:='DD58';
end;

procedure TDD58f1.FormDestroy(Sender: TObject);
(*This, from HWG version, is a nice touch... but not central
     to the operation of this program. It and what's in FormCreate
     save you the hassle of re-entering your usual details
     each time you start the program. Works fine if no
     ini file present when prgm first run.*)
var F : TIniFile;
begin
  F := TIniFile.Create( ChangeFileExt( Application.ExeName, '.ini' ) );
  F.WriteString( 'Settings', 'IPAddress', IPAddress.Text );
  F.WriteString( 'Settings', 'Port', IPPort.Text );
//HWG version was:  F.WriteInteger( 'Settings', 'Port', IPPort.Value );
  F.WriteBool( 'Settings', 'FilterEcho', NVTFiltr.Checked );
  F.WriteBool( 'Settings', 'HexOut', HexOutput.Checked );
end;

procedure TDD58f1.CloseBtnClick(Sender: TObject);
begin
  Close;
end;

procedure TDD58f1.laHWGTxtClick(Sender: TObject);
begin
showmessage('Not implemented. Skeleton in place.');
//  ShellExecute( 0, 'open', 'http://www.hwgroup.cz', nil, nil, SW_NORMAL );
end;

procedure TDD58f1.laTomasTxtClick(Sender: TObject);
begin
showmessage('Not implemented. Skeleton in place.');
//  ShellExecute( 0, 'open', 'mailto:dresler@hw.cz', nil, nil, SW_NORMAL );
end;

procedure TDD58f1.laIOContTxtClick(Sender: TObject);
begin
showmessage('Not implemented. Skeleton in place.');
//  ShellExecute( 0, 'open', 'http://www.hwgroup.cz/products/charon1/index_en.html',
//    nil, nil, SW_NORMAL );
end;

procedure TDD58f1.ClientSocketSessionClosed(Sender: TObject;
  ErrCode: Word);
(*From ICS documentation:
      The OnSessionClosed event is generated when the socket is
      closed, either by an explicit call to the close method or
      by the remote side closing the connection.
  Replaces HWG version's ClientSocketDisconnect*)
begin
  buConnect.Caption := '&Connect';
  HandleButtons( false );
end;

procedure TDD58f1.IPPortChange(Sender: TObject);
//No SpinEdit component in Delphi 2, so data validation done this way.
var boTmp:boolean;
    sTmp:string;
    c1:byte;
begin
boTmp:=true;//innocent til proven guilty
sTmp:=IPPort.text;
for c1:=1 to length(sTmp) do
  if pos(sTmp[c1],'0123456789')=0 then boTmp:=false;
if length(sTmp)<1 then boTmp:=false;
if boTmp then buConnect.enabled:=true else buConnect.enabled:=false;
end;

procedure TDD58f1.LED0Click(Sender: TObject);
//Used for handling change of all output checkboxes
begin
 bTmp:=(
    Ord(LED0.Checked ) shl 0 +
    Ord(LED1.Checked ) shl 1 +
    Ord(LED2.Checked ) shl 2 +
    Ord(LED3.Checked ) shl 3 +
    Ord(LED4.Checked ) shl 4 +
    Ord(LED5.Checked ) shl 5 +
    Ord(LED6.Checked ) shl 6 +
    Ord(LED7.Checked ) shl 7 );
WriteLEDs(bTmp);

end;

procedure TDD58f1.cbReadRepeatedlyClick(Sender: TObject);
begin
if cbReadRepeatedly.checked then begin
  buReadInputs.enabled:=false;
  Timer1.enabled:=true;
  end // no ; here
  else begin
  Timer1.enabled:=false;
  buReadInputs.enabled:=true;
  end;
end;

procedure TDD58f1.Timer1Timer(Sender: TObject);
begin
ReadInputs;
TickTock;
end;

procedure TDD58f1.TickTock;
begin
if shTickTock.brush.color<>clRed then
   shTickTock.brush.color:=clRed else // no ; here
   shTickTock.brush.color:=clBlue;
end;

procedure TDD58f1.buPrettyPatternClick(Sender: TObject);
//Outputs change when checkbox changed due to OnChange handler.
begin
buPrettyPattern.enabled:=false;
buConnect.enabled:=false;
/// crude... sorry!...
LED1.checked:=false;LED2.checked:=false;
LED3.checked:=false;LED4.checked:=false;
LED5.checked:=false;LED6.checked:=false;
LED7.checked:=false;
//end of 1st crude bit.
LED0.checked:=true;
iPP:=1;
timer2.enabled:=true;
end;

procedure TDD58f1.Timer2Timer(Sender: TObject);
//Outputs change when checkbox changed due to OnChange handler.
begin
DoWriteLEDs(iPP);
/// crude... sorry!...
case iPP of
1:begin LED0.checked:=false;LED1.checked:=true;end;
2:begin LED1.checked:=false;LED2.checked:=true;end;
4:begin LED2.checked:=false;LED3.checked:=true;end;
8:begin LED3.checked:=false;LED4.checked:=true;end;
16:begin LED4.checked:=false;LED5.checked:=true;end;
32:begin LED5.checked:=false;LED6.checked:=true;end;
64:begin LED6.checked:=false;LED7.checked:=true;end;
end;//case, and of crude bit.
if iPP=128 then begin
    timer2.enabled:=false;
    buPrettyPattern.enabled:=true;
    LED0.checked:=false;
    buConnect.enabled:=true;
    LED7.checked:=false
    end // no ; here
    else iPP:=iPP*2;
end;

procedure TDD58f1.IPAddressChange(Sender: TObject);
begin
if (buConnect.caption='&Connect') then
   if (boValidIPAddr(IPAddress.text))
      then buConnect.enabled:=true // no ; here
      else buConnect.enabled:=false;
end;

function TDD58f1.boValidIPAddr(sTmp:string):boolean;
(*Returns true if sTmp holds valid IP Address, i.e. 'aa.bb.cc.dd'
        where aa, bb, cc, dd decimal numbers 0-255 inclusive.
  I can't believe I wrote this, and wrote it so badly.
  I'll bet there's one within Piette's ICS!*)
var c1:integer;
    c2,bLenWhole:byte;
    s:array[0..3] of string[4];
begin
result:=true;//innocent until proved guilty
c1:=1;
c2:=0;(*PLEASE say this can be used for loop? I said this routine badly coded!*)
bLenWhole:=length(sTmp);
s[0]:='';s[1]:='';s[2]:='';s[3]:='';
while (c1<=bLenWhole) and (sTmp[c1]<>'.') do begin
   s[c2]:=s[c2]+sTmp[c1];
   inc(c1);
   end;
inc(c1);
inc(c2);
while (c1<=bLenWhole) and (sTmp[c1]<>'.') do begin
   s[c2]:=s[c2]+sTmp[c1];
   inc(c1);
   end;
inc(c1);
inc(c2);
while (c1<=bLenWhole) and (sTmp[c1]<>'.') do begin
   s[c2]:=s[c2]+sTmp[c1];
   inc(c1);
   end;
inc(c1);
inc(c2);
while (c1<=bLenWhole) do begin
   s[c2]:=s[c2]+sTmp[c1];
   inc(c1);
   end;
(*"end" of thing that should(?) be done with "for c2:=0 to 3"
  note last iteration is special case.*)

(*s[0]-s[3] now hold the four parts of the ip addr. If there weren't
      four, the extra emelents hold '' *)
//showmessage(s[0]+'M'+s[1]+'M'+s[2]+'M'+s[3]);
for c2:=0 to 3 do try
c1:=strtoint(s[c2]);
if c1>255 then result:=false;
if c1<0 then result:=false;
except
on EConvertError do result:=false;
end;// of "try", and of "For.. do" statement which had no "begin",
             //so needs no "end";
end;//boValidIPAddr

procedure TDD58f1.SendTxtKeyPress(Sender: TObject; var Key: Char);
//this just so pressing enter when in "send text" edit box sends it,
//  "enter" being an alternative to clicking the "Send" button.
begin
if key=#13 then begin
  SendBtnClick(self);//Ignore the "self" part.. not important
  key:=#0;
  end;
end;

end.
