unit DD60u1; //"Delphi Demo 60"
//serious current problem: top memo doesn't always "show"
//  when it should.

//sometimes gets caught in a "can't create \.temper.xml file" situation...
// EFCreateError... should go when write-to-file replaced with
// write to memory stream.... or will same fault just arise with
// memory stream??

// SOMEWHAT MESSY "tidy on close" stuff.... (see above, for instance.)

//Problem WILL arise if two instances running, and both writing to
// same data file.

//Problem likely to arise if two instances running, and response from
// Poseidon still being sent to .\temper.xml file. Improve warnings, etc.
// Can't use same data file!!

//SORRY... lots of rough edges at the moment... in midst
//of an upgrade... works, thoujgh, I think!!!

(*This program is meant to be a starting point for your own
programming. You may re-cycle elements of this program in
your own work, but please include the credits discussed
below.

It does not pretend to be elegant or complete (although it
DOES "work"!) It is a "bare bones" differential thermostat
for use with a Poseidon XML thermometer. (Poseidon from
"HW group", http://www.hwgroup.cz.)

Please note that this program is not typical of my programming
style and conventions. If you are trying to learn Delphi programming,
you will be better served by the things at....
http://sheepdogguides.com/tut.htm

=====================

SORRY! At the moment, there is a lot of "debris" in the program...
HttpCLi1 was written out, as was XReadTtures... but I wanted to
leave the scraps for later study. The program now "runs on" HttpCli2 and
ReadTTuresNew.

The program is "bare bones" so that you can
  see the essential elements which need to be working
  before your well made program can be created!

While I am not new to computers or to programming, I am fairly
  new to TCP/IP programming, and to the Poseidon. But maybe that
  makes me a good companion for others who are just starting?

It would be quite easy to adapt the program to read from a different
  set of sensors, by a different transport mechanism. See the
  ReadTemperatures procedure.

This program* would not have been possible without the splendid
  Internet Component Suite by Franois Piette. (See more below.)

The program* relies heavily on the ICS demo program "HttpTst". I have
  left many scraps from that in place, remmed out. At the moment,
  frankly, I don't know what half of them are for. If you know,
  you might want to re-incorporate them!.. but my program WORKS,
  even if it doesn't handle problems gracefully, etc.

Fear not! If you, like me, dislike the
  idea of installing third party components into your Delphi, I
  would say to you: This* is a time to make an exception! There
  are versions of ISC for Delphis 1- at least 7, and other languages.
  It is supplied with many demos written in Delphi, and a helpfile.

The program derives from the Charon(Client) program from "HWG",
  www.hw-group.com, the source of the Poseidon. I think that
  little remains, apart from some control names, but if you see
  a resemblance, or reference to HWG, it is no coincidence.

Items marked "*": These comments apply only so long as you leave
  the program fetching it's temperature readings via the XML mechanism.
  
====================
The program was written with Delphi 2.0, plus components from
  Franois Piette's Internet Component Suite, which is free,
  and can be used in commercial derivatives. You can download it from

   www.overbyte.be (N.B.: "BE", not "COM")
   See descriptions there of the many sample applications provided
     with ICS

My Delphi 2 compiler has only had the first 3 components (WSocket,
    WSocketE, WSocketS), and the HTTPProt components added to it.

You only need the ICS components if you wish to fetch the
    temperature readings via the XML mechanism.

============================

The program does nothing to your registry, etc. It does create an
   ini file (DD60ini.txt) to "remember" things like the IP Address
   you specified for your Poseidon. It is put in the exe's folder.

Before you can run this program, you need to set up a Poseidon with
   one or more temperature sensors. If pointing your browser at
   <Poseidon IP Address/temper.xml does not produce some text talking
   about what the Poseidon is seeing, this program will not yet run.

=================
Credits: This material is (c) TK Boyd, 6/05, but you may use it if...

You give credit in your sourcecode, including a reference to
Delphi Tutorials: http://sheepdogguides.com/tut.htm
and
Franois Piette's Internet Components Suite,
http:// www.overbyte.be (N.B.: "BE", not "COM")

If your program is little changed from this program, I would be
grateful if one or both of the above web links appeared on
what users see when they run the program, or if they pop up
an "about" panel. However, if your program is significantly changed
from mine, I'll understand if you "bury" these references.

When I say "you may use it", I include use in commercial products.

Please note: Any such use is allowed only if you accept responsibility
for all consequences arising.

=================

See "procedure TDD60f1.ReadTtures;" for the "heart" of
this program. Note the several event handlers serving HttpCli1.

*)

{=========
 =========
 Misc........

To do...Sort out units display on ttures
Write up that "initialized" variable explicitly init's, which wasn't done
   in ics example.
revive "mailto" button(s)?

Add display of state of Poseidon inputs. Not hard.

- <Temper>
- <Binary>
- <R1>
  <Name>Binary 1</Name>
  <Number>Input1</Number>
  <Value>O</Value>
  <Alarm>Open</Alarm>
  <State>2</State>
  </R1>



}

(*
Annoying flaw: Can't seem to hide memos sensibly, in spite of a bunch
    of code attempting same. Crude "answer" is working.

When comment says "In HWG version, was...", it is reporting what
   statement was modified for the ICS environment. Not all revised
   statements are thus marked. These statements were in fact mostly
   modified in moving from a "HW group" program to DD59,
   which was the "parent" of this program, DD60.

*)
(*History, new at top. Dates: Version ID

28 June: Acquired constant cCSVSep to define separator between fields in CSV
              datafile output. Using ; because comma makes problems in
              places where comma is decimal separator.

28 June: Now uses sensor names from .xml to label table on form.

25 June: Made compensation for regional DecimalSeparator automatic.*)

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons, WSocket, HttpProt, ComCtrls;

type
  TDD60f1 = class(TForm)
    IPAddress: TEdit;
    IPPort: TEdit;
    laIPAddrTxt: TLabel;
    laIPPortTxt: TLabel;
    buQuit: TButton;
    laCredits1txt: TLabel;
    laCredits2txt: TLabel;
    HttpCli1: THttpCli;
    buReadTtures: TButton;
    DisplayMemo: TMemo;
    DocumentMemo: TMemo;
    laTS1: TLabel;
    laTS2: TLabel;
    buReadRepeatedly: TButton;
    Timer1: TTimer;
    laEmailHWgroup: TLabel;
    laBrowseSheepdogGuides: TLabel;
    Image1: TImage;
    buShowHideMemos: TButton;
    laTS3: TLabel;
    laTS4: TLabel;
    laTS5: TLabel;
    laTS6: TLabel;
    laTS7: TLabel;
    laGapMeaning: TLabel;
    Shape1: TShape;
    cbSaveTofile: TCheckBox;
    buSTFHelp: TButton;
    cbFixedname: TCheckBox;
    Timer2: TTimer;
    laTOD: TLabel;
    paFreqSelect: TPanel;
    rbFastest: TRadioButton;
    rb20Sec: TRadioButton;
    rb40Sec: TRadioButton;
    rb2Min: TRadioButton;
    rb5Min: TRadioButton;
    rb10min: TRadioButton;
    laSampFreqTxt: TLabel;
    laHideMemosTxt: TLabel;
    InfoLabel: TLabel;
    HttpCli2: THttpCli;
    buHelp: TButton;
    laSName1: TLabel;
    laSName2: TLabel;
    laSName3: TLabel;
    laSName4: TLabel;
    laSName5: TLabel;
    laSName6: TLabel;
    laSName7: TLabel;
    laLineToData7: TLabel;
    laLineToData6: TLabel;
    laLineToData5: TLabel;
    laLineToData4: TLabel;
    laLinetoData3: TLabel;
    laLinetoData2: TLabel;
    laLineToData1: TLabel;

    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure buQuitClick(Sender: TObject);
    procedure IPPortChange(Sender: TObject);
    procedure HttpCli1RequestDone(
                 Sender  : TObject;
                 RqType  : THttpRequest;
                 ErrCode : Word);
    procedure HttpCli1Command(Sender: TObject; var S: string);
    procedure HttpCli1DocBegin(Sender: TObject);
    procedure HttpCli1DocEnd(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure buReadTturesClick(Sender: TObject);
    procedure buReadRepeatedlyClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure laBrowseSheepdogGuidesClick(Sender: TObject);
    procedure laEmailHWgroupClick(Sender: TObject);
    procedure IPAddressChange(Sender: TObject);
    procedure buShowHideMemosClick(Sender: TObject);
    procedure buSTFHelpClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Timer2Timer(Sender: TObject);
    procedure rbFastestClick(Sender: TObject);
    procedure rb20SecClick(Sender: TObject);
    procedure rb40SecClick(Sender: TObject);
    procedure rb2MinClick(Sender: TObject);
    procedure rb5MinClick(Sender: TObject);
    procedure rb10minClick(Sender: TObject);
    procedure HttpCli2DocData(Sender: TObject; Buffer: Pointer;
      Len: Integer);
    procedure HttpCli2HeaderData(Sender: TObject);
    procedure HttpCli2RequestDone(Sender: TObject; RqType: THttpRequest;
      ErrCode: Word);
    procedure HttpCli2Command(Sender: TObject; var S: string);
    procedure buHelpClick(Sender: TObject);

  private
    { Private declarations }
    Initialized : Boolean;//code with ICS seems to assume this inits in known state.
    DocFileName, sUnits: String;
    boHideDoc,boHideDisp,boOutputFileOpen:boolean;
    bOnDiff:byte;
    iLineInMemo:integer;//Sloppy prgmming... a global "passing" variable
    siTS:array[1..7] of single;
    iDispMemoWidth,iDocMemoWidth: integer;
    //here begin variables for wrap-with-gap graphics
    iGraphWidth,iGapWidth,iNextX,iNextXBlank,iGraphHeight:integer;
    clPlot:array[1..7] of TColor;
    dfOut:textfile;
    //..end grpah variables
    //DataOut : TMemoryStream;
    procedure XReadTtures;
    procedure ReadTturesNew;
    procedure Display(const Msg : String);
    function boValidIPAddr(sTmp:string):boolean;
    procedure EnableReads(boTmp:boolean);
    procedure MemoShowHide(boTmp:Boolean);
    procedure PlotTtures;
    procedure PlotPoint(iX:integer;siUnScaledY:single;bChan:byte);
    procedure UseInfoInTemperXML;
    //"Error": I should have called the next two "iScaleY" and "sDatestamp"
    function ScaleY(siUnscY:single;bChan:byte):integer;
    function Datestamp:string; //used in two places.
    //"error": two more names missing type descriptors...
    function FindTemperTag:boolean;
    function FindSensorsTag:boolean;
    function FindNameTag:boolean;
    function ReadTtureFrmXML(sLine:string):string;
    function ReadNameFrmXML(sLine:string):string;

  public
    { Public declarations }
  end;

var
  DD60f1: TDD60f1;

implementation

uses IniFiles{,Removed from HWG version: ShellAPI.. put back if using click
   on component to email or to browse supplier website.};

{$R *.DFM}

const copyright:string='DD60, TK Boyd 6/05. Derived from the work of others!';
      version='DD60, www.sheepdogsoftware.co.uk, 28 June 2005';//Keep all text
      cCSVSep=';';//Separator between fields in CSV datafile output.
    {Most of following from ICS demo program. Some are probably
        not needed for DD60....}
    IniFileName     = 'DD60ini.txt';
    IniFilePath     = '.\';//Using './' places ini file in exe's folder.
    SectionWindow   = 'WindowMain';
    KeyTop          = 'Top';
    KeyLeft         = 'Left';
    KeyWidth        = 'Width';
    KeyHeight       = 'Height';
    SectionData     = 'Data';
    KeyUrl          = 'URL';
    KeyProxyHost    = 'ProxyHost';
    KeyProxyPort    = 'ProxyPort';
    KeyProxyUser    = 'ProxyUser';
    KeyProxyPass    = 'ProxyPass';
    KeyData         = 'Data';
    KeyDateTime     = 'DateTime';
    KeyHttpVer      = 'HttpVer';
    KeyPostType     = 'PostContentType';
    KeyCookie       = 'CookieToSend';
    KeyDisplayHdr   = 'DisplayHeader';
    KeyNoBasicAuth  = 'DisableBasicAuth';
    KeyNoNTLMAuth   = 'DisableNTLMAuth';
    KeyNoReloc      = 'DoNotFollowRelocation';

    sFileWithXML='.\temper.xml';//It should NOT be necessary to write to file!!
             //To Master: TMemoryStream!!!

procedure TDD60f1.FormCreate(Sender: TObject);
(*Most of this, from HWG version, is a nice touch... but not
     all of it is central to our needs. Some of it and what's in
     FormDestroy save you the hassle of re-entering your usual
     details each time you start the program. Works fine whether
     or not ini file present when prgm is first run.
  See also FormShow. Division of labor more coincidence than plan*)
var F : TIniFile;
    Bitmap:TBitmap;
const defaultIPAddr='Set to Poseidon''s';
begin
  Initialized:=false;
  application.helpfile:='DD60help.hlp';
  timer1.interval:=900;//probably about minimum that makes sense.
     //Change which freq select radio button is pre-checked if interval preset changed
  if paramcount=0 then showmessage('Welcome. The program isn''t perfect'+#13+
    'yet, but it''s getting there. It works okay for'+#13+
    'doezens of readings, and then has trouble writing a'+#13+
    'scratchpad file. If you don''t use the "fastest"'+#13+
    'read frequency, you may not see the problem. If you start the'+#13+
    'program with a command line parameter, and this'+#13+
    'message will be suppressed.'+#13+
    ''+#13+
    ''+#13+
    ''+#13+
    '');
  boOutputFileOpen:=false;
  Bitmap:=TBitmap.create;//Create bitmap to draw graph on
  Bitmap.width:=Image1.width;//see http://sheepdogguides.com/dt3b.htm for details
           //the graphics techniques used in this program.
  Bitmap.height:=Image1.height;
  Image1.Picture.Graphic:=Bitmap;
  Image1.Picture.Bitmap.canvas.font.size:=14;
  Image1.Picture.Bitmap.canvas.pen.color:=clWhite;
  //Here begins code involved in "wrap around with gap" initialisation
  iGraphWidth:=Bitmap.width;
  iGraphHeight:=Bitmap.height;
  iGapWidth:=25;
  if iGapWidth>=iGraphWidth then showmessage('fatal flaw. contact sheepdogsoftware.co.uk');
  iNextX:=0;
  iNextXBlank:=iGapWidth;
  //..end init wrap-w-gap

  //Here begins setup of graph line colors..
  // Revise program to allow user to select color mapping!
  clPlot[1]:=clRed;
  clPlot[2]:=clBLue;
  clPlot[3]:=clBlack;
  clPlot[4]:=clGray;
  clPlot[6]:=clGreen;
  clPlot[7]:=clTeal;
  clPlot[5]:=clOlive;
  //..end graph line colors

  //Crude... can be made more elegant...
  laSName1.font.color:=clPlot[1];
  laSName2.font.color:=clPlot[2];
  laSName3.font.color:=clPlot[3];
  laSName4.font.color:=clPlot[4];
  laSName5.font.color:=clPlot[5];
  laSName6.font.color:=clPlot[6];
  laSName7.font.color:=clPlot[7];
  //

  MemoShowHide(true);//proved "impossible" to start program with memos hidden!
     //If you find a way, let me know! Remember: My "problem" may be a Delphi 2 bug.
  buShowHideMemos.caption:='Hide Memos';
  F := TIniFile.Create(IniFilePath+IniFileName);
  //HWG (or was it ICS?) version had ChangeFileExt(Application.ExeName, '.ini')
     //instead of (IniFilePath+IniFileName)
  IPAddress.Text := F.ReadString( 'Settings', 'IPAddress', defaultIPAddr );
  IPPort.Text := F.ReadString( 'Settings', 'Port', '80' );
  //Width        := IniFile.ReadInteger(SectionWindow, KeyWidth,  Width);
  bOnDiff:=F.ReadInteger('Settings', 'DifferenceToTurnOn', 5);
  F.Free;
  EnableReads(boValidIPAddr(IPAddress.text));
  iDispMemoWidth:=369;//This cannot be picked up from DisplayMemo.width
      //at this point... width still 0, component not yet drawn.
      //Doesn't work to put in "on show", either.
  iDocMemoWidth:=iDispMemoWidth;
end; //FormCreate

procedure TDD60f1.FormShow(Sender: TObject);
(*This from ICS demo, with "cuttings down" by TKB, but few
    "improvements"!
 See also FormCreate. Division of labor more coincidence than plan*)
var
    IniFile : TIniFile;
    //wsi     : TWSADATA;
begin
      if not Initialized then begin
        Initialized  := TRUE;
        {SEE FORMCREATE FOR IniFile manip
        IniFile      := TIniFile.Create(IniFileName);
        Width        := IniFile.ReadInteger(SectionWindow, KeyWidth,  Width);
        Height       := IniFile.ReadInteger(SectionWindow, KeyHeight, Height);
        Top          := IniFile.ReadInteger(SectionWindow, KeyTop,
                                            (Screen.Height - Height) div 2);
        Left         := IniFile.ReadInteger(SectionWindow, KeyLeft,
                                            (Screen.Width  - Width)  div 2);
        URLEdit.Text       := IniFile.ReadString(SectionData, KeyURL,       '');
        ProxyHostEdit.Text := IniFile.ReadString(SectionData, KeyProxyHost, '');
        ProxyPortEdit.Text := IniFile.ReadString(SectionData, KeyProxyPort, '80');
        ProxyUserEdit.Text := IniFile.ReadString(SectionData, KeyProxyUser, '');
        ProxyPassEdit.Text := IniFile.ReadString(SectionData, KeyProxyPass, '');
        DataEdit.Text      := IniFile.ReadString(SectionData, KeyData,      '');
        DateTimeEdit.Text  := IniFile.ReadString(SectionData, KeyDateTime,  '');
        PostContentTypeEdit.Text := IniFile.ReadString(SectionData, KeyPostType, 'text/plain');
        CookieEdit.Text          := IniFile.ReadString(SectionData, KeyCookie,   '');
        HttpVersionComboBox.ItemIndex := IniFile.ReadInteger(SectionData, KeyHttpVer, 0);
        DisplayHeaderCheckBox.Checked := Boolean(IniFile.ReadInteger(SectionData, KeyDisplayHdr,  0));
        NoBasicAuthCheckBox.Checked   := Boolean(IniFile.ReadInteger(SectionData, KeyNoBasicAuth, 0));
        NoNTLMAuthCheckBox.Checked    := Boolean(IniFile.ReadInteger(SectionData, KeyNoNTLMAuth,  0));
        NoRelocCheckBox.Checked       := Boolean(IniFile.ReadInteger(SectionData, KeyNoReloc,     0));
        IniFile.Free; }
        //Panel2.BevelOuter := bvNone;
        { Display version info for program and used components }
        //wsi := WinsockInfo;
        DisplayMemo.Clear;
        Display(CopyRight);
        Display(version);
        DD60f1.caption:='PoseiTtureLogger, '+version;
        Application.title:='DD60';
        Display('Using:');
        Display('   ' + WSocket.CopyRight);//How can this work? It DOES.. but why??
        Display('   ' + HttpProt.CopyRight);
        Display('    Winsock:');
        Display('        Version ' +
                Format('%d.%d', [WinsockInfo.wHighVersion shr 8,
                                 WinsockInfo.wHighVersion and 15]));
       // Display('        ' + StrPas(@wsi.szDescription));
       // Display('        ' + StrPas(@wsi.szSystemStatus));
{$IFNDEF VER100}
        { A bug in Delphi 3 makes lpVendorInfo invalid }
        //if wsi.lpVendorInfo <> nil then
            //Display('        ' + StrPas(wsi.lpVendorInfo));
{$ENDIF}
    end;
//MemoShowHide(false);
end;//FormShow

procedure TDD60f1.FormDestroy(Sender: TObject);
(*Most of this, from HWG version, is a nice touch... but not
     all of it is central to our needs. Some of it and what's in
     FormCreate save you the hassle of re-entering your usual
     details each time you start the program. Works fine if no
     ini file present when prgm first run.*)
var F : TIniFile;
begin
  F := TIniFile.Create(IniFilePath+IniFileName);
  F.WriteString( 'Settings', 'IPAddress', IPAddress.Text );
  F.WriteString( 'Settings', 'Port', IPPort.Text );
  F.WriteInteger('Settings', 'DifferenceToTurnOn', bOnDiff);
end; //FormDestroy

procedure TDD60f1.buQuitClick(Sender: TObject);
begin
  if copy(buReadRepeatedly.caption,1,4)='Stop' then buReadRepeatedlyClick(self);
  close;
end;

procedure TDD60f1.IPPortChange(Sender: TObject);
//No SpinEdit component in Delphi 2, so data validation done this way.
var boTmp:boolean;
    sTmp:string;
    c1:byte;
begin
boTmp:=true;//innocent til proved guilty
sTmp:=IPPort.text;
for c1:=1 to length(sTmp) do
  if pos(sTmp[c1],'0123456789')=0 then boTmp:=false;
if length(sTmp)<1 then boTmp:=false;
EnableReads(boTmp);
end; //IPPortChange

procedure TDD60f1.HttpCli1RequestDone(
    Sender  : TObject;
    RqType  : THttpRequest;
    ErrCode : Word);
(*An event handler for HttpCli1
  This from ICS demo, with "cuttings down" by TKB, but no
    improvements!*)
begin
    if ErrCode <> 0 then
        Display('RequestDone Error = ' + IntToStr(ErrCode) + '. Status = ' +
                IntToStr(HttpCli1.StatusCode))
    else
        Display('RequestDone, no error. Status =' +
                IntToStr(HttpCli1.StatusCode));
end; //HttpCli1RequestDone

procedure TDD60f1.XReadTtures;
(*This is the heart of this program. It is from the
    ICS demo, renamed.. was "Post", I think. It has
    been "cut down" by TKB, but also this routine has
    had call of UseInfoInTemperXML added at it's end
    to USE the data fetched from the Poseidon by
    sending it the "http://<IPAddr>/temper.xml" request.

If you felt the program needed optimising, large parts
    of this could be moved to a do-once-at-beginning
    part of the program.

ReadTtures "only" has to fill the memo called DocumentMemo with something like.....
<br><br>
<pre>
&lt;Poseidon&gt;
&lt;Temper&gt;76.1&lt;/Temper&gt;
&lt;Temper&gt;73.7&lt;/Temper&gt;
&lt;/Poseidon&gt;</pre>

If you want to work with the program, but have no Poseidon, just fix it so
that ReadTtures puts something like the above in DocumentMemo each time
it is called.

By the way- a little plea: Never abbreviate "temperature" to "temp", please?
"Temp", with me, always registers as "temporary". "Tture" makes such a nice,
unambiguous, abbreviation.*)

var
    DataOut : TMemoryStream;
    DataIn  : TFileStream;
    Buf     : String;
    I       : Integer;
    Request:THttpRequest;
begin
    Request:=httpGET;
    DisplayMemo.Clear;
    DocumentMemo.Clear;

    try
        DataOut := TMemoryStream.Create;
        Buf     := '';//DataEdit.Text;
        if Length(Buf) > 0 then      { Check if some data to post }
            DataOut.Write(Buf[1], Length(Buf));
        DataOut.Seek(0, soFromBeginning);

        //if NoBasicAuthCheckBox.Checked then
          //  HttpCli1.Options      := HttpCli1.Options + [httpoNoBasicAuth]
        //else
            HttpCli1.Options      := HttpCli1.Options - [httpoNoBasicAuth];
        {if NoNTLMAuthCheckBox.Checked then
            HttpCli1.Options      := HttpCli1.Options + [httpoNoNTLMAuth]
        else }
            HttpCli1.Options      := HttpCli1.Options - [httpoNoNTLMAuth];
        HttpCli1.FollowRelocation := true;//not NoRelocCheckbox.Checked;
        HttpCli1.SendStream       := DataOut;
        HttpCli1.Proxy            := '';// ProxyHostEdit.Text;
        HttpCli1.ProxyPort        := IPPort.Text;
        HttpCli1.Connection       := 'Keep-Alive';
        HttpCli1.RcvdStream       := nil;
        HttpCli1.ContentTypePost  := 'text/plain';//PostContentTypeEdit.Text;
        HttpCli1.Cookie           := '';//CookieEdit.Text;
        HttpCli1.URL              := 'http://'+IPAddress.text+'/temper.xml';//URLEdit.Text;
        HttpCli1.RequestVer       := '1.0';//'1.' +
                                   //  IntToStr(HttpVersionComboBox.ItemIndex);

        if HttpCli1.Proxy <> '' then
            Display('Using proxy ''' + HttpCli1.Proxy + ':' +
                                  HttpCli1.ProxyPort + '''')
        else
            Display('Not using proxy');

        try
            if Request = httpPOST then
                HttpCli1.Post
            else
                HttpCli1.Put;
        except
            DataOut.Free;
            Display('POST Failed !');
            Display('StatusCode   = ' + IntToStr(HttpCli1.StatusCode));
            Display('ReasonPhrase = ' + HttpCli1.ReasonPhrase);
            Exit;
        end;
        DataOut.Free;

        Display('StatusCode = ' + IntToStr(HttpCli1.StatusCode) +
                ' (' + HttpCli1.ReasonPhrase + ')');

        {if DisplayHeaderCheckBox.Checked then
            for I := 0 to HttpCli1.RcvdHeader.Count - 1 do
                Display('hdr>' + HttpCli1.RcvdHeader.Strings[I]);
         }
        if HttpCli1.ContentLength = 0 then
            DocumentMemo.Lines.Add('No document received.')
        else begin
            DataIn := TFileStream.Create(HttpCli1.DocName, fmOpenRead);
            try
                if Copy(HttpCli1.ContentType, 1, 5) = 'text/' then
                    DocumentMemo.Lines.LoadFromStream(DataIn)
                else begin
                    DocumentMemo.Lines.Add('Content type is ' +
                                           HttpCli1.ContentType);
                    DocumentMemo.Lines.Add('Document stored in ''' +
                                           DocFileName +
                                           ''' Size=' + IntToStr(DataIn.Size));
                end;
            finally
                DataIn.Free;
            end;
        end;
    finally
       // SetButtonState(TRUE);
    end;

MemoShowHide(not boHideDoc);
UseInfoInTemperXML;

end; //ReadTtures

function TDD60f1.FindTemperTag:boolean;
(*Tries to skip to next line with <Temper> in it.
Returns true if, e.g., "<Temper>68.1</Temper>" line found.
Messy code. Uses external, global iLineInMemo to work through
lines in following, and...

Assumes DocumentMemo holds something like...
<Temper><Binary><R1><Name>Binary 1</Name>
<Number>... snip...

<Temper>68.1</Temper>
<TempRange>-10 .. -5</TempRange>
<Alarm>Enabled</Alarm>
<State>2</State>
</Entry><Entry><Name>&quot;Y&quot;</Name>
<Type>1-Wire</Type>
<ID>33280</ID>
<Temper>67.2</Temper>
...snip...</Temper>

From which we wish to extract the 68.1 and the 67.2

AT ONE TIME, ROUTINE DID NOT BEHAVE NICELY IF 2nd '<Temper>' NOT FOUND..
  still true? (May be true if NO temper avail apart from 1st line, which
  isn't a temperature reading.)

New code "bolted on" to find and use info in <name>... note done with
great care, and depends on ORDER of sections (<binary>/<sensors>) in
tmper.xml
*)
begin //FindTemperTag
result:=false;
while (copy(DocumentMemo.lines[iLineInMemo],1,8)<>'<Temper>')
   and (DocumentMemo.lines.count>iLineInMemo)
    do inc(iLineInMemo);
if copy(DocumentMemo.lines[iLineInMemo],1,8)='<Temper>'then result:=true;
   //Could not equal target if last line of xml reached.
end; //FindTemperTag

function TDD60f1.FindSensorsTag:boolean;
(*Tries to skip to next line with <Sensors> in it.
Returns true if, e.g., "<Sensors>" line found.
Messy code. Uses external, global iLineInMemo to work through
lines in temper.xml. See notes in TemperTag.
Probably would be best to create a general FindTag routine*)

begin
result:=false;
while (pos('<Sensors>',DocumentMemo.lines[iLineInMemo])=0)
   and (DocumentMemo.lines.count>iLineInMemo)
    do inc(iLineInMemo);
if pos('<Sensors>',DocumentMemo.lines[iLineInMemo])<>0 then result:=true;
   //Could not equal target if last line of xml reached.
end; //FindSensorsTag

function TDD60f1.FindNameTag:boolean;
(*Tries to skip to next line with <Name> in it.
Returns true if, e.g., "<Name>Oil tture</Name>" line found.
Messy code. Uses external, global iLineInMemo to work through
lines in temper.xml. See notes in TemperTag.
Probably would be best to create a general FindTag routine*)

begin
result:=false;
while (pos('<Name>',DocumentMemo.lines[iLineInMemo])=0)
   and (DocumentMemo.lines.count>iLineInMemo)
    do inc(iLineInMemo);
if pos('<Name>',DocumentMemo.lines[iLineInMemo])<>0 then result:=true;
   //Could not equal target if last line of xml reached.
end; //FindNameTag

function TDD60f1.ReadTtureFrmXML(sLine:string):string;
(*Reads number from a line of text returned from Poseidon's temper.xm
  page. Assumes something like "<Temper>68.1</Temper>"
  passed in sLine.
  Returns the "68.1" part, which can be shorter or longer.
  //BAD PROGRAMMING: Fixable: Also sets value in sUnits*)
var sTmp:string;
    bTmp:byte;
begin
sTmp:='';
bTmp:=9;
while sLine[bTmp]<>'<' do begin
  sTmp:=sTmp+sLine[bTmp];
  inc(bTmp);
  end;
result:=sTmp;
end; //ReadTtureFrmXML

function TDD60f1.ReadNameFrmXML(sLine:string):string;
(*Reads string from a line of text returned from Poseidon's temper.xm
  page. Assumes something like "<Name>Oil Tture</Name>"
  passed in sLine.
  Returns the "Oil Tture" part*)
var sTmp:string;
    bTmp:byte;
begin
sTmp:='';
bTmp:=pos('<Name>',sLine)+6;
while sLine[bTmp]<>'<' do begin
  sTmp:=sTmp+sLine[bTmp];
  inc(bTmp);
  end;
result:=sTmp+'    ';//spaces: to provide gap before line to data
end; //ReadNameFrmXML

procedure TDD60f1.Display(const Msg : String);
(*Show something in memo.
  This from ICS demo, with "cuttings down" by TKB, but few
    "improvements"!*)
begin
    DisplayMemo.Lines.BeginUpdate;
    try
        if DisplayMemo.Lines.Count > 200 then begin
            { We preserve only 200 lines }
            while DisplayMemo.Lines.Count > 200 do
                DisplayMemo.Lines.Delete(0);
        end;
        DisplayMemo.Lines.Add(Msg);
    finally
        DisplayMemo.Lines.EndUpdate;
        { Makes last line visible }
        {$IFNDEF VER80}
        SendMessage(DisplayMemo.Handle, EM_SCROLLCARET, 0, 0);
        {$ENDIF}
    end;
MemoShowHide(not boHideDoc);
end; //Display

procedure TDD60f1.HttpCli1Command(Sender: TObject; var S: string);
(*This from ICS demo*)
begin
    Display('cmd> ' + s);
end;

procedure TDD60f1.HttpCli1DocBegin(Sender: TObject);
(*An event handler for HttpCli1
  This from ICS demo, with "cuttings down" by TKB, but no
    improvements!*)
begin
    Display(HttpCli1.ContentType + ' => ' + HttpCli1.DocName);
    Display('Location = ' + HttpCli1.Location);
    Display('URL = ' + HttpCli1.URL);
    Display('Document = ' + HttpCli1.DocName);

    DocFileName := HttpCli1.DocName;

    if HttpCli1.ContentType = 'image/gif' then
        ReplaceExt(DocFileName, 'gif')
    else if HttpCli1.ContentType = 'image/jpeg' then
        ReplaceExt(DocFileName, 'jpg')
    else if HttpCli1.ContentType = 'image/bmp' then
        ReplaceExt(DocFileName, 'bmp');

    if DocFileName = '' then
        DocFileName := 'HttpTst.htm';
    try
        HttpCli1.RcvdStream := TFileStream.Create(DocFileName, fmCreate);
    except
        on E:Exception do begin
            Display('Error opening file: ' + E.Message);
            DocFileName := 'HttpTst.htm';
            Display('Using default file name: ' + DocFileName);
            HttpCli1.RcvdStream := TFileStream.Create(DocFileName, fmCreate);
        end;
    end;
MemoShowHide(not boHideDoc);//writing to memo undoes "hide"
end; //HttpCli1DocBegin

procedure TDD60f1.HttpCli1DocEnd(Sender: TObject);
(*An event handler for HttpCli1
  This from ICS demo, with "cuttings down" by TKB, but no
    improvements!*)
begin
    if HttpCli1.RcvdStream <> nil then begin
        HttpCli1.RcvdStream.Free;
        HttpCli1.RcvdStream := nil;
    end;
end;

procedure TDD60f1.buReadTturesClick(Sender: TObject);
begin
ReadTturesNew;
end;

procedure TDD60f1.buReadRepeatedlyClick(Sender: TObject);
var sTmp:string;
begin
if timer1.enabled=false then begin
  if buShowHideMemos.caption='Hide Memos'
       then buShowHideMemosClick(self);//A little weird... don't worry about it!
      //The "self" is just to keep buShow... happy... it isn't used.
  //Prepare output file...
  if cbSaveTofile.checked=true then begin
    boOutputFileOpen:=true;
    if cbFixedname.checked then sTmp:='./DD60Data.txt' // no ; here
      else begin
      sTmp:='./DD60d'+copy(DateStamp,1,12)+'.txt';//yyymmddhhmm
      end;//of else
    AssignFile(dfOut,sTmp);
    Rewrite(dfOut);
    //end prep output file
    end;//ifcbSave...
  timer1.enabled:=true;
  IPAddress.enabled:=false;
  IPPort.enabled:=false;
  cbSaveTofile.enabled:=false;
  cbFixedname.enabled:=false;
  rbFastest.enabled:=false;
  rb20Sec.enabled:=false;
  rb40Sec.enabled:=false;
  rb2Min.enabled:=false;
  rb5Min.enabled:=false;
  rb10min.enabled:=false;


  buReadRepeatedly.caption:='Stop Reading Repeatedly';
  //'Stop' used elsewhere to signal loop is active.
  
  ReadTturesNew; //do initial read & plot, because "1st" is otherwise at end of
    //first timer timeout
  PlotTtures;
  end // no ; here
 else begin
  //Close output file, if open
  boOutputFileOpen:=false;
  closefile(dfOut);
  //end of close
  timer1.enabled:=false;
  IPAddress.enabled:=true;
  IPPort.enabled:=true;
  cbSaveTofile.enabled:=true;
  cbFixedname.enabled:=true;
  rbFastest.enabled:=true;
  rb20Sec.enabled:=true;
  rb40Sec.enabled:=true;
  rb2Min.enabled:=true;
  rb5Min.enabled:=true;
  rb10min.enabled:=true;


  buReadRepeatedly.caption:='Read Repeatedly';
end;
end; //buReadRepeatedlyClick

procedure TDD60f1.Timer1Timer(Sender: TObject);
//Heart of "Read repeatedly" mechanism
begin
ReadTturesNew;
PlotTtures;
end;

procedure TDD60f1.laBrowseSheepdogGuidesClick(Sender: TObject);
begin
showmessage('Not implemented. Skeleton in place.');
//  ShellExecute( 0, 'open', 'http://sheepdogsoftware.co.uk',
//    nil, nil, SW_NORMAL );
end;

procedure TDD60f1.laEmailHWgroupClick(Sender: TObject);
begin
showmessage('Not implemented. Skeleton in place.');
//  ShellExecute( 0, 'open', 'mailto://www.hwgroup.cz/products/charon1/index_en.html',
//    nil, nil, SW_NORMAL );
end;

procedure TDD60f1.IPAddressChange(Sender: TObject);
begin
EnableReads(boValidIPAddr(IPAddress.text));
end;

function TDD60f1.boValidIPAddr(sTmp:string):boolean;
(*Returns true if sTmp holds valid IP Address, i.e. 'aa.bb.cc.dd'
        where aa, bb, cc, dd decimal numbers 0-255 inclusive.
  I can't believe I wrote this, and wrote it so badly.
  I'll bet there's one ithin Piette's ICS!*)
var c1:integer;
    c2,bLenWhole:byte;
    s:array[0..3] of string[4];
begin
result:=true;//innocent until proved guilty
c1:=1;
c2:=0;(*PLEASE say this can be used for loop? I said this routine badly coded!*)
bLenWhole:=length(sTmp);
s[0]:='';s[1]:='';s[2]:='';s[3]:='';
while (c1<=bLenWhole) and (sTmp[c1]<>'.') do begin
   s[c2]:=s[c2]+sTmp[c1];
   inc(c1);
   end;
inc(c1);
inc(c2);
while (c1<=bLenWhole) and (sTmp[c1]<>'.') do begin
   s[c2]:=s[c2]+sTmp[c1];
   inc(c1);
   end;
inc(c1);
inc(c2);
while (c1<=bLenWhole) and (sTmp[c1]<>'.') do begin
   s[c2]:=s[c2]+sTmp[c1];
   inc(c1);
   end;
inc(c1);
inc(c2);
while (c1<=bLenWhole) do begin
   s[c2]:=s[c2]+sTmp[c1];
   inc(c1);
   end;
(*"end" of thing that should(?) be done with "for c2:=0 to 3"
  note last iteration is special case.*)

(*s[0]-s[3] now hold the four parts of the ip addr. If there weren't
      four, the extra emelents hold '' *)
//showmessage(s[0]+'M'+s[1]+'M'+s[2]+'M'+s[3]);
for c2:=0 to 3 do try
c1:=strtoint(s[c2]);
if c1>255 then result:=false;
if c1<0 then result:=false;
except
on EConvertError do result:=false;
end;// of "try", and of "For.. do" statement which had no "begin",
             //so needs no "end";
end;//boValidIPAddr

procedure TDD60f1.EnableReads(boTmp:boolean);
//Called from various places. If true, buttons to cause reading of
     //temperatures are enabled.
begin
if boTmp then begin
   buReadTtures.enabled:=true;
   buReadRepeatedly.enabled:=true;
   //cbSaveTofile.enabled:=true;
   //cbFixedname.enabled:=true;
  end // no ; here
  else begin
   buReadTtures.enabled:=false;
   buReadRepeatedly.enabled:=false;
   //cbSaveTofile.enabled:=false;
   //cbFixedname.enabled:=false;
  end;
end;

procedure TDD60f1.MemoShowHide(boTmp:Boolean);
(*Pass true, and memos shown; pass false to "hide" memos
There may be a bug in Delphi 2... I have trouble hiding
memos simply by setting their visible property false.
This procedure encapsulates all showing/hiding of the
"Display" and "Document" memos.
Doing a show before a hide causes flicker... but makes hide work!
*)
begin
if boTmp then begin //show memos
    DocumentMemo.width:=iDocMemoWidth;
    DisplayMemo.width:=iDispMemoWidth;
    DocumentMemo.show;
    DisplayMemo.show;
  end //no ; here
 else begin //hide memos
  DisplayMemo.show;//without the show, the hide won't work!
  DocumentMemo.show;
  DisplayMemo.hide;
  DocumentMemo.hide;
  DisplayMemo.width:=0;//crude "hide"... so no flicker seen
  DocumentMemo.width:=0;
  end;
end;//MemoShowHide

procedure TDD60f1.buShowHideMemosClick(Sender: TObject);
begin
if buShowHideMemos.caption='Show Memos' then begin
   buShowHideMemos.caption:='Hide Memos';
   boHideDoc:=false;//Unfortunate naming conventions "just happened"
   boHideDisp:=false;//Says HIDE memo
   MemoShowHide(true);//SHOWS memos
   laHideMemosTxt.visible:=true;
   end//no ; here
  else begin
   buShowHideMemos.caption:='Show Memos';
   boHideDoc:=true;
   boHideDisp:=true;
   MemoShowHide(false);
   laHideMemosTxt.visible:=false;
   end;
end;//buShowHideMemosClick

procedure TDD60f1.PlotPoint(iX:integer;siUnScaledY:single;bChan:byte);
begin
Image1.Picture.Bitmap.canvas.pixels[iX,ScaleY(siUnScaledY,bChan)]:=clPlot[bChan];
end;

function TDD60f1.ScaleY(siUnscY:single;bChan:byte):integer;
//bChan not used yet, but leave in place: It may be desireable
// to scale different channels differently, if only to offset.
begin
result:=iGraphHeight-round(siUnscY)-50;
end;

procedure TDD60f1.PlotTtures;
//Badly written: too many global variables referenced, and should use loop.
var c1:byte;
begin
for c1:=1 to 7 do begin
  if siTS[c1]<>-999 then PlotPoint(iNextX,siTS[c1],c1);
  end;
Image1.Picture.Bitmap.canvas.moveto(iNextXBlank,0);
Image1.Picture.Bitmap.canvas.lineto(iNextXBlank,iGraphHeight);
inc(iNextX);
if iNextX>iGraphWidth then begin
     iNextX:=0;
     laGapMeaning.caption:='Data at left of gap is newest, at right, oldest.';
     end;
inc(iNextXBlank);
if iNextXBlank>iGraphWidth then begin
     iNextXBlank:=0;
     end;
end;

procedure TDD60f1.UseInfoInTemperXML;
///Here begins USE the info read from the webpage....
//  Some assumptions made about where lines start... but note that "<Sensors>" tag
//     NOT presumed to start a line.
function sDecimalSeparator(sTmp:string):string;
//convert, say, 23.5 to 23,5
//Posedon always returns the former, but
//Delphi strtofloat DOES take not of regional settings, and
//if set saying that 23-and-a-half will be shown as 23,6,
//(as in Czech Republic!!) then throws "invalid number" if
//given 23.5
begin
if pos('.', sTmp) > 0 then
    sTmp[pos('.', sTmp)] :=DecimalSeparator;
result:=sTmp;
end;

var sReading,sNameD,sName,sLineForDatafile,sTmp:string;
    c1:integer;
    boFoundOne:boolean;
begin //UseInfoInTemperXML
    sNameD:='';//default value for sensor name field.
    laSName1.caption:=sNameD;//+'1' possible, if wanted
    laSName2.caption:=sNameD;
    laSName3.caption:=sNameD;
    laSName4.caption:=sNameD;
    laSName5.caption:=sNameD;
    laSName6.caption:=sNameD;
    laSName7.caption:=sNameD;

sLineForDatafile:=Datestamp;
for c1:=1 to 7 do siTS[c1]:=-999;//rogue. Used elsewhere
iLineInMemo:=2;//Skip over the "<Temper>" at start of file
c1:=1;
boFoundOne:=FindSensorsTag;//Skip to Sensors section. Weakness... assumes there IS at least one <Sensors>
//  if boFoundOne then sTmp:='true' else sTmp:='false';
//  showmessage('Just did findsensorstag. Returned '+sTmp);
boFoundOne:=FindNameTag;//Weakness... assumes there IS at least one <Name>, in <Sensors> section
//  if boFoundOne then sTmp:='true' else sTmp:='false';
//  showmessage('Just did first findnametag. Returned '+sTmp);
while boFoundOne do begin
  sName:=ReadNameFrmXML(DocumentMemo.lines[iLineInMemo]);
  boFoundOne:=FindTemperTag;//Weakness... assumes there IS at a <Temper> following the <Name>
  sReading:=ReadTtureFrmXML(DocumentMemo.lines[iLineInMemo]);
  //Very bad programming.. fixable.. ReadTtureFrmXML and ReadNameFrmXML ALSO set value in sUnits
  sUnits:=' deg';
  if copy(sReading,length(sReading),1)='%' then begin
    //begin deal with humidity returned as a "temper"
    sUnits:=' %';
    sReading:=copy(sReading,1,length(sReading)-2);
    end;

  if DecimalSeparator<>'.' then sReading:=sDecimalSeparator(sReading);
  //My first use of DecimalSeparator. To enable prgram to run where
  //locale uses something other than a decimal point, e.g. Prague!

  case c1 of //yes... crude! Not hard to rewrite.
    1:laSName1.caption:=sName;
    2:laSName2.caption:=sName;
    3:laSName3.caption:=sName;
    4:laSName4.caption:=sName;
    5:laSName5.caption:=sName;
    6:laSName6.caption:=sName;
    7:laSName7.caption:=sName;
    end;//case

  case c1 of //yes... crude! Not hard to rewrite.
    //Why two "case"s? To avoid a bunch of begin/ends
    1:laTS1.caption:=sReading+sUnits;
    2:laTS2.caption:=sReading+sUnits;
    3:laTS3.caption:=sReading+sUnits;
    4:laTS4.caption:=sReading+sUnits;
    5:laTS5.caption:=sReading+sUnits;
    6:laTS6.caption:=sReading+sUnits;
    7:laTS7.caption:=sReading+sUnits;
    end;//case

  siTS[c1]:=strtofloat(sReading);
  sLineForDatafile:=sLineForDatafile+cCSVSep+sReading;
  inc(iLineInMemo);
  inc(c1);
  boFoundOne:=FindNameTag;
  end;//while. =iLinesInMemo;//fencepost error may exist.

if boOutputFileOpen then writeln(dfOut,sLineForDatafile);

end; // UseInfoInTemperXML

procedure TDD60f1.buSTFHelpClick(Sender: TObject);
var sTmp:string;
begin
sTmp:='This is a demo program. As such some'+#13+
  'shortcuts have been taken. One is'+#13+
  'the fact that only data captured during'+#13+
  '"Read Repeatedly" is written to the program''s'+#13+
  'datafile. Another is that you get no choice of'+#13+
  'datafile name. It will be DD60<date/time>.txt'+#13+
  'and it will be in the same directory as the .exe file.'+#13+
  ''+#13+
  'If you tick "Fixed filename" the file will be saved'+#13+
  'as DD60Data.txt, and any old file of that name will be'+#13+
  'overwritten.'+#13+
  ''+#13+
  'If you start "Read Repeatedly" twice within the same minute,'+#13+
  'the first file of data will be overwritten.'+#13+
  ''+#13+
  'You may or MAY NOT get away with running two or more instances'+#13+
  ' of the program at the same time... but you will have trouble'+#13+
  'if you try to save data from both the the same file!';
showmessage(sTmp);
end;

procedure TDD60f1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
//Occurs regardless of whether form closed with buQuit or with "x" in upper right.
begin
(*Didn't work...
if HttpCli2.RcvdStream<>nil then begin
  HttpCli2.RcvdStream.Destroy;
  end;
  *)

//while  HttpCli2.RcvdStream<>nil do application.processmessages;

(*Didn't work.. still got "cannot create file"... DURING close!!*)
if boOutputFileOpen then begin
 CloseFile(dfOut);
 boOutputFileOpen:=false;
 end;

while boOutPutFileOpen do application.processmessages;
//Trust that other threads WILL close...

CanClose:=true;
end;

function TDD60f1.DateStamp:string;
//Probably best if there are no spaces, as one use
//is to supply part of a filename.
//Turns 1:02:03pm 5Nov, 2005 into 20051105130203... always 4+2+2+2+2+2 digits.
var sTmp:string;
    Instant:Tdatetime;
    Year, Month, Day, Hour, Min, Sec, MSec: Word;
begin
Instant:=Now;
DecodeDate(Instant, Year, Month, Day);
DecodeTime(Instant, Hour, Min, Sec, MSec);
result:='';
sTmp:=inttostr(Year);
while length(sTmp)<4 do sTmp:='0'+sTmp;
result:=result+sTmp;
sTmp:=inttostr(Month);
while length(sTmp)<2 do sTmp:='0'+sTmp;
result:=result+sTmp;
sTmp:=inttostr(Day);
while length(sTmp)<2 do sTmp:='0'+sTmp;
result:=result+sTmp;
sTmp:=inttostr(Hour);
while length(sTmp)<2 do sTmp:='0'+sTmp;
result:=result+sTmp;
sTmp:=inttostr(Min);
while length(sTmp)<2 do sTmp:='0'+sTmp;
result:=result+sTmp;
sTmp:=inttostr(Sec);
while length(sTmp)<2 do sTmp:='0'+sTmp;
result:=result+sTmp;
end;//DateStamp
procedure TDD60f1.Timer2Timer(Sender: TObject);
//Merely for putting time of day on screeen.
begin
laTOD.caption:=timetostr(Now);
end;

procedure TDD60f1.rbFastestClick(Sender: TObject);
begin
Timer1.interval:=2000;
end;

procedure TDD60f1.rb20SecClick(Sender: TObject);
begin
Timer1.interval:=20000;
end;

procedure TDD60f1.rb40SecClick(Sender: TObject);
begin
Timer1.interval:=40000;
end;

procedure TDD60f1.rb2MinClick(Sender: TObject);
begin
Timer1.interval:=120000;
end;

procedure TDD60f1.rb5MinClick(Sender: TObject);
begin
Timer1.interval:=300000;
end;

procedure TDD60f1.rb10minClick(Sender: TObject);
begin
Timer1.interval:=600000;
end;

//===========
// HERE BEGINS SECTION which arose when "heart transplanted": The GetXML
//"stuff" had been from the ICS demo HttpTst, but was replaced with
//modified HttpGet. Old way: OK on LAN, no use on internet!

(*Any scraps useful?


 {$R *.DFM}
const
    SectionData   = 'Data';
    KeyURL        = 'URL';
    KeyProxyHost  = 'ProxyHost';
    KeyProxyPort  = 'ProxyPort';
    KeyFileName   = 'FileName';
    SectionWindow = 'Window';
    KeyTop        = 'Top';
    KeyLeft       = 'Left';
    KeyWidth      = 'Width';
    KeyHeight     = 'Height';

*)
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
(*Any scraps useful?

procedure THttpGetForm.FormCreate(Sender: TObject);
begin
    FIniFileName := LowerCase(ExtractFileName(Application.ExeName));
    FIniFileName := Copy(FIniFileName, 1, Length(FIniFileName) - 3) + 'ini';
    InfoLabel.Caption := '';
end;
*)

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
(*Any scraps useful?

procedure THttpGetForm.FormShow(Sender: TObject);
var
    IniFile : TIniFile;
begin
    if not FInitialized then begin
        FInitialized       := TRUE;
        IniFile            := TIniFile.Create(FIniFileName);
        URLEdit.Text       := IniFile.ReadString(SectionData, KeyURL,
                              'http://www.rtfm.be/fpiette/images/overbyte.gif');
        ProxyHostEdit.Text := IniFile.ReadString(SectionData, KeyProxyHost,
                              '');
        ProxyPortEdit.Text := IniFile.ReadString(SectionData, KeyProxyPort,
                              '80');
        FileNameEdit.Text  := IniFile.ReadString(SectionData, KeyFileName,
                              'test.tmp');
        Top    := IniFile.ReadInteger(SectionWindow, KeyTop,    Top);
        Left   := IniFile.ReadInteger(SectionWindow, KeyLeft,   Left);
        Width  := IniFile.ReadInteger(SectionWindow, KeyWidth,  Width);
        Height := IniFile.ReadInteger(SectionWindow, KeyHeight, Height);
        IniFile.Free;
    end;
end;
*)

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
(*Any scraps useful?

procedure THttpGetForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
var
    IniFile : TIniFile;
begin
    IniFile := TIniFile.Create(FIniFileName);
    IniFile.WriteString(SectionData, KeyURL,       URLEdit.Text);
    IniFile.WriteString(SectionData, KeyProxyHost, ProxyHostEdit.Text);
    IniFile.WriteString(SectionData, KeyProxyPort, ProxyPortEdit.Text);
    IniFile.WriteString(SectionData, KeyFileName,  FileNameEdit.Text);
    IniFile.WriteInteger(SectionWindow, KeyTop,    Top);
    IniFile.WriteInteger(SectionWindow, KeyLeft,   Left);
    IniFile.WriteInteger(SectionWindow, KeyWidth,  Width);
    IniFile.WriteInteger(SectionWindow, KeyHeight, Height);
    IniFile.Free;
end;
  *)
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
(*reconsider...
procedure THttpGetForm.HttpCli1DocData(Sender: TObject; Buffer: Pointer;
  Len: Integer);
begin
    InfoLabel.Caption := IntToStr(HttpCli1.RcvdCount);
end;
*)


{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
(*reconsider...
procedure THttpGetForm.HttpCli1HeaderData(Sender: TObject);
begin
    InfoLabel.Caption := InfoLabel.Caption + '.';
end;

*)
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
(*Reinstate!
procedure THttpGetForm.AbortButtonClick(Sender: TObject);
begin
    HttpCli1.Abort;
end;
*)

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
//===========


procedure TDD60f1.ReadTTuresNew;
//Derived from ICS demo HttpGet//THttpGetForm.GetButtonClick(Sender: TObject);
//TO BE adapted to pass xml to TMemoryStream instead of a disc file.
//Absurd kludge at moment: Fetches XML, puts in file in disc, and then copies to memo! BAH!
//There are scraps in this of attempts to achieve that.

(*This is the heart of this program. It is from the
    ICS demo, HttpGet...proc was "GetButtonClick". It has
    been "cut down" by TKB, but also this routine has
    had call of UseInfoInTemperXML added at it's end
    to USE the data fetched from the Poseidon by
    sending it the "http://<IPAddr>/temper.xml" request.

If you felt the program needed optimising, parts
    of this could be moved to a do-once-at-beginning
    part of the program.

ReadTtures "only" has to fill the memo called DocumentMemo with something like.....
<br><br>
<pre>
&lt;Poseidon&gt;
&lt;Temper&gt;76.1&lt;/Temper&gt;
&lt;Temper&gt;73.7&lt;/Temper&gt;
&lt;/Poseidon&gt;</pre>

If you want to work with the program, but have no Poseidon, just fix it so
that ReadTtures puts something like the above in DocumentMemo each time
it is called.

By the way- a little plea: Never abbreviate "temperature" to "temp", please?
"Temp", with me, always registers as "temporary". "Tture" makes such a nice,
unambiguous, abbreviation.

Lines marked //# are not essential to the basic operation of this
routine, but they add information for the user. They came from the other
program (HttpTst), which was where my first attempt at DD60's heart
came from*)

begin
    DisplayMemo.Clear;  //#
    DocumentMemo.Clear; //#
//DataOut.Create;
    HttpCli2.URL        := 'http://'+IPAddress.text+'/temper.xml';//URLEdit.Text;
    HttpCli2.Proxy      := '';//ProxyHostEdit.Text;
    HttpCli2.ProxyPort  := '80';//ProxyPortEdit.Text;
    HttpCli2.RcvdStream := TFileStream.Create(sFileWithXML, fmCreate);//DataOut;//TFileStream.Create(FileNameEdit.Text, fmCreate);
//    AbortButton.Enabled := TRUE;
    InfoLabel.Caption   := 'Loading';
    if HttpCli2.Proxy <> '' then //#
          Display('Using proxy ''' + HttpCli2.Proxy + ':' +
                                  HttpCli2.ProxyPort + '''')
        else //#
          Display('Not using proxy');

    try  //1
        try //2
            HttpCli2.Get;
            InfoLabel.Caption := 'Received ' +
                                 IntToStr(HttpCli2.RcvdStream.Size) + ' bytes';
            //DataOut.position:=0;
            //sTmp:=

        except //2
            on E: EHttpException do begin
                InfoLabel.Caption := 'Failed : ' +
                                     IntToStr(HttpCli2.StatusCode) + ' ' +
                                             HttpCli2.ReasonPhrase;
                Display('POST Failed !');//#
                Display('StatusCode   = ' + IntToStr(HttpCli2.StatusCode));//#
                Display('ReasonPhrase = ' + HttpCli2.ReasonPhrase);//#

            end //case
            else
                raise;
        end; //try..except //1
    finally //1
    //MAYBE also useful... OnRequestDone handler... but moving things
    //   there "broke" routine!!!

//        AbortButton.Enabled := FALSE;
        HttpCli2.RcvdStream.Destroy;
        HttpCli2.RcvdStream := nil;
        Display('StatusCode = ' + IntToStr(HttpCli2.StatusCode) +
                ' (' + HttpCli2.ReasonPhrase + ')');  //#

        DocumentMemo.Lines.LoadFromFile(sFileWithXML);

        MemoShowHide(not boHideDoc);//TKB, not ICS
        UseInfoInTemperXML;//TKB, not ICS

//        DataOut.Free;
    end; //try..finally //1

end;

procedure TDD60f1.HttpCli2DocData(Sender: TObject; Buffer: Pointer;
  Len: Integer);
begin
InfoLabel.Caption := IntToStr(HttpCli2.RcvdCount);
end;

procedure TDD60f1.HttpCli2HeaderData(Sender: TObject);
begin
InfoLabel.Caption := InfoLabel.Caption + '.';
end;

procedure TDD60f1.HttpCli2RequestDone(Sender: TObject;
  RqType: THttpRequest; ErrCode: Word);
//See note in proc with HttpCli2.Get;
begin
//HttpCli2.RcvdStream.Destroy;
//HttpCli2.RcvdStream:=nil;
//DataOut.Free;
//DocumentMemo.Lines.LoadFromFile(sFileWithXML);
//DataOut.position:=0;
//DocumentMemo.Lines.LoadFromStream(DataOut);
//DataOut.Free;
//GetButton.Enabled   := TRUE;
end;

procedure TDD60f1.HttpCli2Command(Sender: TObject; var S: string);
(*This from ICS HttpTst demo*)
begin
    Display('cmd> ' + s);
end;

// HERE ENDS SECTION which arose when "heart transplanted"

procedure TDD60f1.buHelpClick(Sender: TObject);
begin
application.helpcommand(HELP_CONTENTS,0);//access external helpfile
end;

end.
