unit DS033U1;
(*Demo code showing how to drive a DS2409 MicroLan Coupler

  MicroLan is an alias for 1-Wire. The latter is used more
  commonly at the sites I see, but gives search engines and
  abbreviators problems. (OW: "One Wire"... or is that Zero W?)

  In this, DML, for Dallas MicroLan, is used extensively
  to prefix names so that this can be exported to other
  environments with minimal name clash problems. Where a
  name does not include DML, the object is probably not
  central to what needs to be exported.

  Created by TK Boyd. If you use it, a credit, and reference
  to www.sheepdogsoftware.co.uk would be welcome.

  There is a document on the web discussing this software.*)

(*DS033 may need work on error codes.*)
(*CONSIDER: CAN D1 cope with cardinal type?*)

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, iBTMEXPW, ExtCtrls;
  (*iBTMEXPW.PAS is supplied by Dallas as part of the TMEX SDK
    There are several ways to make what is needed available
    to Delphi. The easiest is simply to keep a copy of iBTMEXPW.pas
    in the folder with your .pas file*)

const
  ver='4 Sept 04';
  //DS033 derived from DS029, ver 25 June 03
  //DS033 started 28 Jly 04 for Springbok modules, IDM110
  kDMLRomIndexMax=4;(*Determines maximum number of
     devices that can be accessed. If 4, 5 devices
     possible. Unused elements waste some memory. Not
     important to this program as presented,
     but useful if program extended.*)

type
  TDS033f1 = class(TForm)
    buQuit: TButton;
    Label3: TLabel;
    Label4: TLabel;
    laDMLTKBErr: TLabel;
    laDMLDalErr: TLabel;
    buCtrlOn: TButton;
    buCtrlOff: TButton;
    Label5: TLabel;
    buDirectOnMain: TButton;
    laCtrlState: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    procedure buQuitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure buCtrlOnClick(Sender: TObject);
    procedure buCtrlOffClick(Sender: TObject);
    procedure buDirectOnMainClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    rTmp:single;(*type "real" not recommended*)
    bTmp:byte;
    sTmp:string;
    iTmp,iDalErr,iD0,iD1,iD2,iD3,iD4,iD5,iD6,iD7,iD8:integer;
      (*Yes: iD0 to iD8, not 7. Could be done more elegantly... but simple is best?*)
    bTKBErrReturned:byte;
    bDMLRomIndexLast:byte;
    saDMLRomID:array [0..kDMLRomIndexMax] of string[16];
    (*While this example accesses only one chip, it is
      written so that extending it to more is easy.
      saDMLRomID[0] would hold 'A20000000547FB10' if
      the first chip's id were $A20000000547FB10. The
      address is given in the form returned by the
      iButtonViewer (software included in SDK), i.e.
      the right hand byte is the device ID byte.*)
    baDMLRomID:array [0..kDMLRomIndexMax,0..7] of byte;
    (*baDMLRomID[2,0] holds chip 2's first id byte*)
    iDMLPortNum,iDMLAdapterType:integer;
    (*Notes on data TYPES: ver 29 Jly 04...
    Beware: I have before, and may still, have been confused
    over the type expectations of the TMEX interface. I THINK
    that Dallas calls a signed 8bit number a "byte" whereas
    in Delphi-speak a byte is an UNsigned 8 bit number. IF all
    of this program is done right, AND you never have to look
    at the Dallas documentation (seems unlikely!), then you'll
    be okay. If you spot errors on my part in translating from
    the Dallas to the Delphi, please get in touch?
    ...and... just to add to the fun... I think I remember some
    issues regarding changed type definitions (or at least
    types of type available) between the 16 bit Delphi (Delphi ver.1)
    and later versions. That sounds unlikely, so I'm probably
    mis-remembering... but watch out for whatever caught me that
    registered in my memory thus.

    From SDK help file: (except first column)...
    Delphi name Dallas name   Desc
    integer     short         16-bit signed
    longint     long          32-bit signed
    shortint    char          8-bit signed
    byte        unsigned char 8-bit unsigned

    Checked, should be exactly right types:
    iDMLPortNum, iDMLAdapterType,
    liDMLSHandle
    siaDMLRom
    baDMLRom
    iDMLTmpResult... should be i for TMSetup, Access
       and TouchByte, at least. Would be mad to be
       inconsistent... but let me know if one of the
       others returns something different, other than
       TMExtendedStartSession

    (End "Notes on data types") *)

    iDMLTmpResult:integer;
    (*iDMLTmpResult is a 'scratch' variable, never used for
         long-term storage of any value.*)
    liDMLSHandle:longint;
    baDMLStateBuffer:array[0..15361] of byte;
      (*15360 might do, but for one byte, I covered
       the possiblilty that I was misunderstanding
       something in the Dallas docs*)
    siaDMLRom:array[0..8] of smallint;(*Yes: 9 bytes.
       the last isn't used every time, but I think
       it IS used sometimes.

       A curiosity: The type MUST BE SMALLINT...
       I accidentally had this as byte and got
       GPFaults during TMRom call. (Problem
       stuffing $FF into an element?)*)
    cardTmp:cardinal;(*The cardinal type doesn't appear
       in the Delphi 1 helpfiles, but it doesn't cause
       error during compile. Believed to be a 32 bit
       unsigned type. IS BAD IDEA!
       qexpand the cardinal issue*)

//Most of the variables added for DS033...
    bTmpByteReturned:byte;

    procedure DMLInit;

//Most (all?) of the routines added for DS033...
    procedure DMLRomMatch(bIndex:byte;
         var sTKBErr:string;
         var iDalErr:integer);
         
    procedure DMLStatusRW(bIndex,bStatusByte:byte;
         var bByteReturned:byte;
         var sTKBErr:string;
         var iDalErr:integer);

    procedure DMLDirectOnMain(bIndex:byte;
         var sTKBErr:string;
         var iDalErr:integer);


  end;

var
  DS033f1: TDS033f1;

implementation

{$R *.DFM}


procedure TDS033f1.buQuitClick(Sender: TObject);
begin
application.terminate;
end;

procedure TDS033f1.DMLInit;
var c1:byte;
begin
(*Prepare two variables with the facts of your
adapter location and type. There are fancier ways
to do this, and the information can be auto-
detected. This stuff should at least be supplied
to the program as command line parameters in a
non-demo program*)
iDMLPortNum:=5;(*Which serial port your adapter is on*)
iDMLAdapterType:=5;(*Adapter types...
   1:DS9097 with no suffix, 9097E
   5:DS9097U, 9097U-9*)
(*Put the IDs of your Dallas chips into
  the elements of saDMLRomID. You can
  learn your chips' IDs with the iButton viewer.
  Note IDs given with family ID at right hand end.*)
(*              vvvvvvvvvvvvvvvv*)
saDMLRomID[0]:='F400000001F05D1F';
{               CB00000000BAA41F (SX LP-THS)}
bDMLRomIndexLast:=0;

for c1:=0 to bDMLRomIndexLast do begin
 sTmp:=saDMLRomID[c1];
 baDMLRomID[c1,7]:=strtoint('$'+copy(sTmp,1,2));
 baDMLRomID[c1,6]:=strtoint('$'+copy(sTmp,3,2));
 baDMLRomID[c1,5]:=strtoint('$'+copy(sTmp,5,2));
 baDMLRomID[c1,4]:=strtoint('$'+copy(sTmp,7,2));
 baDMLRomID[c1,3]:=strtoint('$'+copy(sTmp,9,2));
 baDMLRomID[c1,2]:=strtoint('$'+copy(sTmp,11,2));
 baDMLRomID[c1,1]:=strtoint('$'+copy(sTmp,13,2));
 baDMLRomID[c1,0]:=strtoint('$'+copy(sTmp,15,2));
  end;(*For...*)
end;(*DMLInit*)

procedure TDS033f1.FormCreate(Sender: TObject);
begin
showmessage('See sourcecode: It must be edited '+
'to set the DS2409 id, and port type and adapter.');
DMLInit;
end;

procedure TDS033f1.DMLRomMatch(bIndex:byte;
         var sTKBErr:string;
         var iDalErr:integer);
(*This procedure prepares the way for sending Function Commands
(Dallas term) to a device. It should be generally useful across
the whole range of 1-Wire chips.

bIndex tells the proc which element of the array baDMLRomID
to access to find the Dallas ID of the chip we want to "talk" to.*)

(*In some Dallas demo code, there seems to be
  places where the code says
  "Couldn't do that first time? Try a few times more"
  In this code, we work through the stages of reading
  a temperature, and if we get a snag at any point,
  we give up. It is up to the calling program to
  re-call this as often as it deems worthwhile.

  N.B. This code does not check that the device it has
  been sent to read is in fact a DS2438 (family code $26).
  That check should be made- elsewhere.*)

var c1:byte;

begin
sTKBErr:='';

liDMLSHandle:=TMExtendedStartSession(iDMLPortNum,
                 iDMLAdapterType,nil);
if liDMLSHandle<1 then begin
  sTKBErr:='10';
  iDalErr:=liDMLSHandle;
  end;

if sTKBErr='' then begin
  iDMLTmpResult:=TMSetUp(liDMLSHandle);
  if iDMLTmpResult<>1 then begin
    sTKBErr:='20';
    iDalErr:=iDMLTmpResult;
    end;
  end;

{Reset/Presence/Skip ROM}
if sTKBErr='' then begin
  for c1:=0 to 7 do siaDMLRom[c1]:=baDMLRomID[bIndex,c1];
  (*Prepare to pass chip ID to a buffer in TMEX driver.
    It MAY not always be necessary to repeatedly refill
    this buffer, but doing so makes this code more generally
    useful.*)
  try (*You could introduce other try... except... end blocks.
        I only put them in where I needed them to work past
        various errors in my code, errors which I hope are
        now gone!*)
  iDMLTmpResult:=TMRom(liDMLSHandle,@baDMLStateBuffer,@siaDMLRom);
  except
  {DID WORK.. REIMPLEMENT...on EGPFault do begin
          bTKBErr:=31;
          iDalErr:=0;
          iDMLTmpResult:=1;
          end;              }
  end;(*Except*)
  if iDMLTmpResult<>1 then begin
    sTKBErr:='30';
    iDalErr:=iDMLTmpResult;
    end;
  end;

if sTKBErr='' (*CSess*) then begin
        iDMLTmpResult:=TMValidSession(liDMLSHandle);
(*Check to see that liDMLSHandle, the session handle, is still
    valid*)
if iDMLTmpResult<>1 then begin
    sTKBErr:='32';
    iDalErr:=iDMLTmpResult;
    end;
end;
(*Here begins: Turn off all devices apart from the
  one you want...*)
if sTKBErr='' then begin
  iDMLTmpResult:=TMStrongAccess(liDMLSHandle,@baDMLStateBuffer);
  if iDMLTmpResult<>1 then begin
    sTKBErr:='40';
    iDalErr:=iDMLTmpResult;
    end;
  end;

{Could? Should? CheckSess occur here?
if sTKBErr='' (*CSess*) then begin
        iDMLTmpResult:=TMValidSession(liDMLSHandle);
if iDMLTmpResult<>1 then begin
    sTKBErr:='42';
    iDalErr:=iDMLTmpResult;
    end;
  end;
}
end;// DMLRomMatch

procedure TDS033f1.DMLStatusRW(bIndex,bStatusByte:byte;
         var bByteReturned:byte;
         var sTKBErr:string;
         var iDalErr:integer);
//It should be possible to improve this code! It works, but is messy.
var bConfirmation:byte;
begin
DMLROMMatch(bIndex,sTmp,iTmp);//To select just chip required

{Issue (i.e. TX, or transmit) Control Function Command,
"Status Read/Write", 5Ah. N.B.: In this context, we are NOT
talking about the "Control" output of the DS2409. However,
Dallas, in the flowchart in their documentation, speaks of
"Control Function Command"s.

(TouchByte with something other than $FF as last byte
writes to the MicroLan)}

if sTKBErr='' then begin
  iDMLTmpResult:=TMTouchByte(liDMLSHandle,$5A);
  if iDMLTmpResult<0 then begin
    sTKBErr:='60';
    iDalErr:=iDMLTmpResult;(*-1 flags shorted ML*)
    end;
end;
{Could? Should? Check Sess occur here?
if bTKBErr=0 (*CSess*) then begin
        iDMLTmpResult:=TMValidSession(liDMLSHandle);
if iDMLTmpResult then begin
    bTKBErr:=62;
    iDalErr:=iDMLTmpResult;
    end;
  end;
}
{Issue required Status Byte to DS2409.}
if sTKBErr='' then begin
  iDMLTmpResult:=TMTouchByte(liDMLSHandle,bStatusByte);
  if iDMLTmpResult<0 then begin
    sTKBErr:='60.1';
    iDalErr:=iDMLTmpResult;(*-1 flags shorted ML*)
    end;
end;
{Could? Should? Check Sess occur here?
if bTKBErr=0 (*CSess*) then begin
        iDMLTmpResult:=TMValidSession(liDMLSHandle);
if iDMLTmpResult then begin
    bTKBErr:=62;
    iDalErr:=iDMLTmpResult;
    end;
  end;
}
{Pick up Status Info Byte, which DS2409 will send at this point
(TouchByte with $FF as last byte reads from MicroLan)
This block of code could probably be optimized!}
if sTKBErr='0' then begin
  iDMLTmpResult:=TMTouchByte(liDMLSHandle,$FF);
  if iDMLTmpResult<0 then begin
    sTKBErr:='60.2';
    iDalErr:=iDMLTmpResult;(*-1 flags shorted ML*)
    end;
  if iDMLTmpResult>255 then begin
    sTKBErr:='60.3';
    iDalErr:=iDMLTmpResult;(*-1 flags shorted ML*)
    end;
  if (iDMLTmpResult>=0)and(iDMLTmpResult<256) then begin
    bByteReturned:=iDMLTmpResult;
    end;
end;
{Could? Should? Check Sess occur here?
if bTKBErr=0 (*CSess*) then begin
        iDMLTmpResult:=TMValidSession(liDMLSHandle);
if iDMLTmpResult then begin
    bTKBErr:=62;
    iDalErr:=iDMLTmpResult;
    end;
  end;
}
{Pick up Confirmation Byte, which DS2409 will send at this point.
 It should be the same as the Status Info Byte sent a moment
 ago.}
if sTKBErr='0' then begin
  iDMLTmpResult:=TMTouchByte(liDMLSHandle,$FF);
  if iDMLTmpResult<0 then begin
    sTKBErr:='60.4';
    iDalErr:=iDMLTmpResult;(*-1 flags shorted ML*)
    end;
  if iDMLTmpResult>255 then begin
    sTKBErr:='60.5';
    iDalErr:=iDMLTmpResult;(*-1 flags shorted ML*)
    end;
  if (iDMLTmpResult>=0)and(iDMLTmpResult<256) then begin
    bConfirmation:=iDMLTmpResult;
    if bByteReturned<>bConfirmation then begin
         sTKBErr:='60.6: Conf byte from 2409 didn''t match '+
         'Status Info Byte';
         iDalErr:=iDMLTmpResult;(*-1 flags shorted ML*)
         end;
    end;
end;
{Could? Should? Check Sess occur here?
if bTKBErr=0 (*CSess*) then begin
        iDMLTmpResult:=TMValidSession(liDMLSHandle);
if iDMLTmpResult then begin
    bTKBErr:=62;
    iDalErr:=iDMLTmpResult;
    end;
  end;
}
end;//DMLStatusRW

procedure TDS033f1.DMLDirectOnMain(bIndex:byte;
         var sTKBErr:string;
         var iDalErr:integer);
{This will set "aux" off and then "main" on. Transistor on
 "Control" output may change.}
var bConfirmation:byte;
begin
DMLROMMatch(bIndex,sTmp,iTmp);//To select just chip required

{Issue (i.e. TX, or transmit) Function Command "Direct-On Main", A5h}
if sTKBErr='' then begin
  iDMLTmpResult:=TMTouchByte(liDMLSHandle,$A5);
  if iDMLTmpResult<0 then begin
    sTKBErr:='60.11';
    iDalErr:=iDMLTmpResult;(*-1 flags shorted ML*)
    end;
end;
{Could? Should? Check Sess occur here?
if bTKBErr=0 (*CSess*) then begin
        iDMLTmpResult:=TMValidSession(liDMLSHandle);
if iDMLTmpResult then begin
    bTKBErr:=62;
    iDalErr:=iDMLTmpResult;
    end;
  end;
}

{Pick up Confirmation Byte, which DS2409 will send at this point.
If all is well, the confirmation byte will be $A5.}
if sTKBErr='0' then begin
  iDMLTmpResult:=TMTouchByte(liDMLSHandle,$FF);
  if iDMLTmpResult<0 then begin
    sTKBErr:='60.14';
    iDalErr:=iDMLTmpResult;(*-1 flags shorted ML*)
    end;
  if iDMLTmpResult>255 then begin
    sTKBErr:='60.15';
    iDalErr:=iDMLTmpResult;(*-1 flags shorted ML*)
    end;
  if (iDMLTmpResult>=0)and(iDMLTmpResult<256) then begin
    bConfirmation:=iDMLTmpResult;
    if bConfirmation<>$A5 then begin
         sTKBErr:='60.16: Direct-On confirmation code wasn''t $A5';
         iDalErr:=iDMLTmpResult;(*-1 flags shorted ML*)
         end;
    end;
end;
{Could? Should? Check Sess occur here?
if bTKBErr=0 (*CSess*) then begin
        iDMLTmpResult:=TMValidSession(liDMLSHandle);
if iDMLTmpResult then begin
    bTKBErr:=62;
    iDalErr:=iDMLTmpResult;
    end;
  end;
}
end;//DMLDirectOnMain

procedure TDS033f1.buCtrlOnClick(Sender: TObject);
//Turn DS2409 output called "Control" on
begin
DMLStatusRW(0,$A0,bTmpByteReturned,sTmp,iDalErr);
laDMLTKBErr.caption:=sTmp;
if sTmp<>'' then laDMLDalErr.caption:=inttostr(iTmp) // no ; here
  else begin
    laDMLDalErr.caption:='<not meaningful>';
    laDMLTKBErr.caption:='No error';
        laCtrlState.caption:='"Control" output should be "On"';
        end;(*else*)
end;

procedure TDS033f1.buCtrlOffClick(Sender: TObject);
//Turn DS2409 output called "Control" off
begin
DMLStatusRW(0,$20,bTmpByteReturned,sTmp,iDalErr);
laDMLTKBErr.caption:=sTmp;
if sTmp<>'' then laDMLDalErr.caption:=inttostr(iTmp) // no ; here
  else begin
    laDMLDalErr.caption:='<not meaningful>';
    laDMLTKBErr.caption:='No error';
    laCtrlState.caption:='"Control" output should be "Off"';
    end;(*else*)
end;

procedure TDS033f1.buDirectOnMainClick(Sender: TObject);
begin
DMLDirectOnMain(0,sTmp,iDalErr);
laDMLTKBErr.caption:=sTmp;
if sTmp<>'' then laDMLDalErr.caption:=inttostr(iTmp) // no ; here
  else begin
    laDMLDalErr.caption:='<not meaningful>';
    laDMLTKBErr.caption:='No error';
    end;(*else*)
end;

end.
